package org.openqa.selenium.devtools.v105.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Depending on the concrete errorType, different properties are set.
 */
public class GenericIssueDetails {

    private final org.openqa.selenium.devtools.v105.audits.model.GenericIssueErrorType errorType;

    private final java.util.Optional<org.openqa.selenium.devtools.v105.page.model.FrameId> frameId;

    public GenericIssueDetails(org.openqa.selenium.devtools.v105.audits.model.GenericIssueErrorType errorType, java.util.Optional<org.openqa.selenium.devtools.v105.page.model.FrameId> frameId) {
        this.errorType = java.util.Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
    }

    /**
     * Issues with the same errorType are aggregated in the frontend.
     */
    public org.openqa.selenium.devtools.v105.audits.model.GenericIssueErrorType getErrorType() {
        return errorType;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v105.page.model.FrameId> getFrameId() {
        return frameId;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v105.audits.model.GenericIssueErrorType errorType = null;
        java.util.Optional<org.openqa.selenium.devtools.v105.page.model.FrameId> frameId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "errorType":
                    errorType = input.read(org.openqa.selenium.devtools.v105.audits.model.GenericIssueErrorType.class);
                    break;
                case "frameId":
                    frameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v105.page.model.FrameId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId);
    }
}
