package org.openqa.selenium.devtools.v104.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when frame has been attached to its parent.
 */
public class FrameAttached {

    private final org.openqa.selenium.devtools.v104.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.v104.page.model.FrameId parentFrameId;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.StackTrace> stack;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.page.model.AdScriptId> adScriptId;

    public FrameAttached(org.openqa.selenium.devtools.v104.page.model.FrameId frameId, org.openqa.selenium.devtools.v104.page.model.FrameId parentFrameId, java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.StackTrace> stack, java.util.Optional<org.openqa.selenium.devtools.v104.page.model.AdScriptId> adScriptId) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.parentFrameId = java.util.Objects.requireNonNull(parentFrameId, "parentFrameId is required");
        this.stack = stack;
        this.adScriptId = adScriptId;
    }

    /**
     * Id of the frame that has been attached.
     */
    public org.openqa.selenium.devtools.v104.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Parent frame identifier.
     */
    public org.openqa.selenium.devtools.v104.page.model.FrameId getParentFrameId() {
        return parentFrameId;
    }

    /**
     * JavaScript stack trace of when frame was attached, only set if frame initiated from script.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.StackTrace> getStack() {
        return stack;
    }

    /**
     * Identifies the bottom-most script which caused the frame to be labelled
     * as an ad. Only sent if frame is labelled as an ad and id is available.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v104.page.model.AdScriptId> getAdScriptId() {
        return adScriptId;
    }

    private static FrameAttached fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v104.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.v104.page.model.FrameId parentFrameId = null;
        java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.StackTrace> stack = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.page.model.AdScriptId> adScriptId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v104.page.model.FrameId.class);
                    break;
                case "parentFrameId":
                    parentFrameId = input.read(org.openqa.selenium.devtools.v104.page.model.FrameId.class);
                    break;
                case "stack":
                    stack = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.runtime.model.StackTrace.class));
                    break;
                case "adScriptId":
                    adScriptId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.page.model.AdScriptId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameAttached(frameId, parentFrameId, stack, adScriptId);
    }
}
