package org.openqa.selenium.devtools.v104.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes.
 * DOMNode is a base node mirror type.
 */
public class Node {

    private final org.openqa.selenium.devtools.v104.dom.model.NodeId nodeId;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> parentId;

    private final org.openqa.selenium.devtools.v104.dom.model.BackendNodeId backendNodeId;

    private final java.lang.Integer nodeType;

    private final java.lang.String nodeName;

    private final java.lang.String localName;

    private final java.lang.String nodeValue;

    private final java.util.Optional<java.lang.Integer> childNodeCount;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> children;

    private final java.util.Optional<java.util.List<java.lang.String>> attributes;

    private final java.util.Optional<java.lang.String> documentURL;

    private final java.util.Optional<java.lang.String> baseURL;

    private final java.util.Optional<java.lang.String> publicId;

    private final java.util.Optional<java.lang.String> systemId;

    private final java.util.Optional<java.lang.String> internalSubset;

    private final java.util.Optional<java.lang.String> xmlVersion;

    private final java.util.Optional<java.lang.String> name;

    private final java.util.Optional<java.lang.String> value;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.PseudoType> pseudoType;

    private final java.util.Optional<java.lang.String> pseudoIdentifier;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.ShadowRootType> shadowRootType;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> contentDocument;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> shadowRoots;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> templateContent;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> pseudoElements;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> importedDocument;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.BackendNode>> distributedNodes;

    private final java.util.Optional<java.lang.Boolean> isSVG;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.CompatibilityMode> compatibilityMode;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNode> assignedSlot;

    public Node(org.openqa.selenium.devtools.v104.dom.model.NodeId nodeId, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> parentId, org.openqa.selenium.devtools.v104.dom.model.BackendNodeId backendNodeId, java.lang.Integer nodeType, java.lang.String nodeName, java.lang.String localName, java.lang.String nodeValue, java.util.Optional<java.lang.Integer> childNodeCount, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> children, java.util.Optional<java.util.List<java.lang.String>> attributes, java.util.Optional<java.lang.String> documentURL, java.util.Optional<java.lang.String> baseURL, java.util.Optional<java.lang.String> publicId, java.util.Optional<java.lang.String> systemId, java.util.Optional<java.lang.String> internalSubset, java.util.Optional<java.lang.String> xmlVersion, java.util.Optional<java.lang.String> name, java.util.Optional<java.lang.String> value, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.PseudoType> pseudoType, java.util.Optional<java.lang.String> pseudoIdentifier, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.ShadowRootType> shadowRootType, java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> contentDocument, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> shadowRoots, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> templateContent, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> pseudoElements, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> importedDocument, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.BackendNode>> distributedNodes, java.util.Optional<java.lang.Boolean> isSVG, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.CompatibilityMode> compatibilityMode, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNode> assignedSlot) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.parentId = parentId;
        this.backendNodeId = java.util.Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.nodeType = java.util.Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = java.util.Objects.requireNonNull(nodeName, "nodeName is required");
        this.localName = java.util.Objects.requireNonNull(localName, "localName is required");
        this.nodeValue = java.util.Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.childNodeCount = childNodeCount;
        this.children = children;
        this.attributes = attributes;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.xmlVersion = xmlVersion;
        this.name = name;
        this.value = value;
        this.pseudoType = pseudoType;
        this.pseudoIdentifier = pseudoIdentifier;
        this.shadowRootType = shadowRootType;
        this.frameId = frameId;
        this.contentDocument = contentDocument;
        this.shadowRoots = shadowRoots;
        this.templateContent = templateContent;
        this.pseudoElements = pseudoElements;
        this.importedDocument = importedDocument;
        this.distributedNodes = distributedNodes;
        this.isSVG = isSVG;
        this.compatibilityMode = compatibilityMode;
        this.assignedSlot = assignedSlot;
    }

    /**
     * Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend
     * will only push node with given `id` once. It is aware of all requested nodes and will only
     * fire DOM events for nodes known to the client.
     */
    public org.openqa.selenium.devtools.v104.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    /**
     * The id of the parent node if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> getParentId() {
        return parentId;
    }

    /**
     * The BackendNodeId for this node.
     */
    public org.openqa.selenium.devtools.v104.dom.model.BackendNodeId getBackendNodeId() {
        return backendNodeId;
    }

    /**
     * `Node`'s nodeType.
     */
    public java.lang.Integer getNodeType() {
        return nodeType;
    }

    /**
     * `Node`'s nodeName.
     */
    public java.lang.String getNodeName() {
        return nodeName;
    }

    /**
     * `Node`'s localName.
     */
    public java.lang.String getLocalName() {
        return localName;
    }

    /**
     * `Node`'s nodeValue.
     */
    public java.lang.String getNodeValue() {
        return nodeValue;
    }

    /**
     * Child count for `Container` nodes.
     */
    public java.util.Optional<java.lang.Integer> getChildNodeCount() {
        return childNodeCount;
    }

    /**
     * Child nodes of this node when requested with children.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> getChildren() {
        return children;
    }

    /**
     * Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.
     */
    public java.util.Optional<java.util.List<java.lang.String>> getAttributes() {
        return attributes;
    }

    /**
     * Document URL that `Document` or `FrameOwner` node points to.
     */
    public java.util.Optional<java.lang.String> getDocumentURL() {
        return documentURL;
    }

    /**
     * Base URL that `Document` or `FrameOwner` node uses for URL completion.
     */
    public java.util.Optional<java.lang.String> getBaseURL() {
        return baseURL;
    }

    /**
     * `DocumentType`'s publicId.
     */
    public java.util.Optional<java.lang.String> getPublicId() {
        return publicId;
    }

    /**
     * `DocumentType`'s systemId.
     */
    public java.util.Optional<java.lang.String> getSystemId() {
        return systemId;
    }

    /**
     * `DocumentType`'s internalSubset.
     */
    public java.util.Optional<java.lang.String> getInternalSubset() {
        return internalSubset;
    }

    /**
     * `Document`'s XML version in case of XML documents.
     */
    public java.util.Optional<java.lang.String> getXmlVersion() {
        return xmlVersion;
    }

    /**
     * `Attr`'s name.
     */
    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    /**
     * `Attr`'s value.
     */
    public java.util.Optional<java.lang.String> getValue() {
        return value;
    }

    /**
     * Pseudo element type for this node.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.PseudoType> getPseudoType() {
        return pseudoType;
    }

    /**
     * Pseudo element identifier for this node. Only present if there is a
     * valid pseudoType.
     */
    public java.util.Optional<java.lang.String> getPseudoIdentifier() {
        return pseudoIdentifier;
    }

    /**
     * Shadow root type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.ShadowRootType> getShadowRootType() {
        return shadowRootType;
    }

    /**
     * Frame ID for frame owner elements.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> getFrameId() {
        return frameId;
    }

    /**
     * Content document for frame owner elements.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> getContentDocument() {
        return contentDocument;
    }

    /**
     * Shadow root list for given element host.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> getShadowRoots() {
        return shadowRoots;
    }

    /**
     * Content document fragment for template elements.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> getTemplateContent() {
        return templateContent;
    }

    /**
     * Pseudo elements associated with this node.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> getPseudoElements() {
        return pseudoElements;
    }

    /**
     * Deprecated, as the HTML Imports API has been removed (crbug.com/937746).
     * This property used to return the imported document for the HTMLImport links.
     * The property is always undefined now.
     */
    @Deprecated()
    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> getImportedDocument() {
        return importedDocument;
    }

    /**
     * Distributed nodes for given insertion point.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.BackendNode>> getDistributedNodes() {
        return distributedNodes;
    }

    /**
     * Whether the node is SVG.
     */
    public java.util.Optional<java.lang.Boolean> getIsSVG() {
        return isSVG;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.CompatibilityMode> getCompatibilityMode() {
        return compatibilityMode;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNode> getAssignedSlot() {
        return assignedSlot;
    }

    private static Node fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v104.dom.model.NodeId nodeId = null;
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> parentId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v104.dom.model.BackendNodeId backendNodeId = null;
        java.lang.Integer nodeType = 0;
        java.lang.String nodeName = null;
        java.lang.String localName = null;
        java.lang.String nodeValue = null;
        java.util.Optional<java.lang.Integer> childNodeCount = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> children = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> attributes = java.util.Optional.empty();
        java.util.Optional<java.lang.String> documentURL = java.util.Optional.empty();
        java.util.Optional<java.lang.String> baseURL = java.util.Optional.empty();
        java.util.Optional<java.lang.String> publicId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> systemId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> internalSubset = java.util.Optional.empty();
        java.util.Optional<java.lang.String> xmlVersion = java.util.Optional.empty();
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        java.util.Optional<java.lang.String> value = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.PseudoType> pseudoType = java.util.Optional.empty();
        java.util.Optional<java.lang.String> pseudoIdentifier = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.ShadowRootType> shadowRootType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> contentDocument = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> shadowRoots = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> templateContent = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>> pseudoElements = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.Node> importedDocument = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v104.dom.model.BackendNode>> distributedNodes = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isSVG = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.CompatibilityMode> compatibilityMode = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNode> assignedSlot = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v104.dom.model.NodeId.class);
                    break;
                case "parentId":
                    parentId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.NodeId.class));
                    break;
                case "backendNodeId":
                    backendNodeId = input.read(org.openqa.selenium.devtools.v104.dom.model.BackendNodeId.class);
                    break;
                case "nodeType":
                    nodeType = input.nextNumber().intValue();
                    break;
                case "nodeName":
                    nodeName = input.nextString();
                    break;
                case "localName":
                    localName = input.nextString();
                    break;
                case "nodeValue":
                    nodeValue = input.nextString();
                    break;
                case "childNodeCount":
                    childNodeCount = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "children":
                    children = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>>() {
                    }.getType()));
                    break;
                case "attributes":
                    attributes = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                    }.getType()));
                    break;
                case "documentURL":
                    documentURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "baseURL":
                    baseURL = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "publicId":
                    publicId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "systemId":
                    systemId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "internalSubset":
                    internalSubset = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "xmlVersion":
                    xmlVersion = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "pseudoType":
                    pseudoType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.PseudoType.class));
                    break;
                case "pseudoIdentifier":
                    pseudoIdentifier = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "shadowRootType":
                    shadowRootType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.ShadowRootType.class));
                    break;
                case "frameId":
                    frameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.page.model.FrameId.class));
                    break;
                case "contentDocument":
                    contentDocument = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.Node.class));
                    break;
                case "shadowRoots":
                    shadowRoots = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>>() {
                    }.getType()));
                    break;
                case "templateContent":
                    templateContent = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.Node.class));
                    break;
                case "pseudoElements":
                    pseudoElements = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.dom.model.Node>>() {
                    }.getType()));
                    break;
                case "importedDocument":
                    importedDocument = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.Node.class));
                    break;
                case "distributedNodes":
                    distributedNodes = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.dom.model.BackendNode>>() {
                    }.getType()));
                    break;
                case "isSVG":
                    isSVG = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "compatibilityMode":
                    compatibilityMode = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.CompatibilityMode.class));
                    break;
                case "assignedSlot":
                    assignedSlot = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.dom.model.BackendNode.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Node(nodeId, parentId, backendNodeId, nodeType, nodeName, localName, nodeValue, childNodeCount, children, attributes, documentURL, baseURL, publicId, systemId, internalSubset, xmlVersion, name, value, pseudoType, pseudoIdentifier, shadowRootType, frameId, contentDocument, shadowRoots, templateContent, pseudoElements, importedDocument, distributedNodes, isSVG, compatibilityMode, assignedSlot);
    }
}
