/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v103.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v103.css.model.FontVariationAxis;
import org.openqa.selenium.json.JsonInput;

public class FontFace {
    private final String fontFamily;
    private final String fontStyle;
    private final String fontVariant;
    private final String fontWeight;
    private final String fontStretch;
    private final String unicodeRange;
    private final String src;
    private final String platformFontFamily;
    private final Optional<List<FontVariationAxis>> fontVariationAxes;

    public FontFace(String fontFamily, String fontStyle, String fontVariant, String fontWeight, String fontStretch, String unicodeRange, String src, String platformFontFamily, Optional<List<FontVariationAxis>> fontVariationAxes) {
        this.fontFamily = Objects.requireNonNull(fontFamily, "fontFamily is required");
        this.fontStyle = Objects.requireNonNull(fontStyle, "fontStyle is required");
        this.fontVariant = Objects.requireNonNull(fontVariant, "fontVariant is required");
        this.fontWeight = Objects.requireNonNull(fontWeight, "fontWeight is required");
        this.fontStretch = Objects.requireNonNull(fontStretch, "fontStretch is required");
        this.unicodeRange = Objects.requireNonNull(unicodeRange, "unicodeRange is required");
        this.src = Objects.requireNonNull(src, "src is required");
        this.platformFontFamily = Objects.requireNonNull(platformFontFamily, "platformFontFamily is required");
        this.fontVariationAxes = fontVariationAxes;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public String getFontStretch() {
        return this.fontStretch;
    }

    public String getUnicodeRange() {
        return this.unicodeRange;
    }

    public String getSrc() {
        return this.src;
    }

    public String getPlatformFontFamily() {
        return this.platformFontFamily;
    }

    public Optional<List<FontVariationAxis>> getFontVariationAxes() {
        return this.fontVariationAxes;
    }

    private static FontFace fromJson(JsonInput input) {
        String fontFamily = null;
        String fontStyle = null;
        String fontVariant = null;
        String fontWeight = null;
        String fontStretch = null;
        String unicodeRange = null;
        String src = null;
        String platformFontFamily = null;
        Optional<List<FontVariationAxis>> fontVariationAxes = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "fontFamily": {
                    fontFamily = input.nextString();
                    continue block22;
                }
                case "fontStyle": {
                    fontStyle = input.nextString();
                    continue block22;
                }
                case "fontVariant": {
                    fontVariant = input.nextString();
                    continue block22;
                }
                case "fontWeight": {
                    fontWeight = input.nextString();
                    continue block22;
                }
                case "fontStretch": {
                    fontStretch = input.nextString();
                    continue block22;
                }
                case "unicodeRange": {
                    unicodeRange = input.nextString();
                    continue block22;
                }
                case "src": {
                    src = input.nextString();
                    continue block22;
                }
                case "platformFontFamily": {
                    platformFontFamily = input.nextString();
                    continue block22;
                }
                case "fontVariationAxes": {
                    fontVariationAxes = Optional.ofNullable((List)input.read(new TypeToken<List<FontVariationAxis>>(){}.getType()));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FontFace(fontFamily, fontStyle, fontVariant, fontWeight, fontStretch, unicodeRange, src, platformFontFamily, fontVariationAxes);
    }
}

