/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v103.systeminfo.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v103.systeminfo.model.Size;
import org.openqa.selenium.json.JsonInput;

public class VideoEncodeAcceleratorCapability {
    private final String profile;
    private final Size maxResolution;
    private final Integer maxFramerateNumerator;
    private final Integer maxFramerateDenominator;

    public VideoEncodeAcceleratorCapability(String profile, Size maxResolution, Integer maxFramerateNumerator, Integer maxFramerateDenominator) {
        this.profile = Objects.requireNonNull(profile, "profile is required");
        this.maxResolution = Objects.requireNonNull(maxResolution, "maxResolution is required");
        this.maxFramerateNumerator = Objects.requireNonNull(maxFramerateNumerator, "maxFramerateNumerator is required");
        this.maxFramerateDenominator = Objects.requireNonNull(maxFramerateDenominator, "maxFramerateDenominator is required");
    }

    public String getProfile() {
        return this.profile;
    }

    public Size getMaxResolution() {
        return this.maxResolution;
    }

    public Integer getMaxFramerateNumerator() {
        return this.maxFramerateNumerator;
    }

    public Integer getMaxFramerateDenominator() {
        return this.maxFramerateDenominator;
    }

    private static VideoEncodeAcceleratorCapability fromJson(JsonInput input) {
        String profile = null;
        Size maxResolution = null;
        Integer maxFramerateNumerator = 0;
        Integer maxFramerateDenominator = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "profile": {
                    profile = input.nextString();
                    continue block12;
                }
                case "maxResolution": {
                    maxResolution = (Size)input.read(Size.class);
                    continue block12;
                }
                case "maxFramerateNumerator": {
                    maxFramerateNumerator = input.nextNumber().intValue();
                    continue block12;
                }
                case "maxFramerateDenominator": {
                    maxFramerateDenominator = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VideoEncodeAcceleratorCapability(profile, maxResolution, maxFramerateNumerator, maxFramerateDenominator);
    }
}

