package org.openqa.selenium.devtools.v102.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * List of FinalStatus reasons for Prerender2.
 */
public enum PrerenderFinalStatus {

    ACTIVATED("Activated");

    private String value;

    PrerenderFinalStatus(String value) {
        this.value = value;
    }

    public static PrerenderFinalStatus fromString(String s) {
        return java.util.Arrays.stream(PrerenderFinalStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PrerenderFinalStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PrerenderFinalStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
