/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.webaudio.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class ContextRealtimeData {
    private final Number currentTime;
    private final Number renderCapacity;
    private final Number callbackIntervalMean;
    private final Number callbackIntervalVariance;

    public ContextRealtimeData(Number currentTime, Number renderCapacity, Number callbackIntervalMean, Number callbackIntervalVariance) {
        this.currentTime = Objects.requireNonNull(currentTime, "currentTime is required");
        this.renderCapacity = Objects.requireNonNull(renderCapacity, "renderCapacity is required");
        this.callbackIntervalMean = Objects.requireNonNull(callbackIntervalMean, "callbackIntervalMean is required");
        this.callbackIntervalVariance = Objects.requireNonNull(callbackIntervalVariance, "callbackIntervalVariance is required");
    }

    public Number getCurrentTime() {
        return this.currentTime;
    }

    public Number getRenderCapacity() {
        return this.renderCapacity;
    }

    public Number getCallbackIntervalMean() {
        return this.callbackIntervalMean;
    }

    public Number getCallbackIntervalVariance() {
        return this.callbackIntervalVariance;
    }

    private static ContextRealtimeData fromJson(JsonInput input) {
        Number currentTime = 0;
        Number renderCapacity = 0;
        Number callbackIntervalMean = 0;
        Number callbackIntervalVariance = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "currentTime": {
                    currentTime = input.nextNumber();
                    continue block12;
                }
                case "renderCapacity": {
                    renderCapacity = input.nextNumber();
                    continue block12;
                }
                case "callbackIntervalMean": {
                    callbackIntervalMean = input.nextNumber();
                    continue block12;
                }
                case "callbackIntervalVariance": {
                    callbackIntervalVariance = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ContextRealtimeData(currentTime, renderCapacity, callbackIntervalMean, callbackIntervalVariance);
    }
}

