package org.openqa.selenium.devtools.v100.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class BackForwardCacheNotRestoredExplanation {

    private final org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReasonType type;

    private final org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReason reason;

    public BackForwardCacheNotRestoredExplanation(org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReasonType type, org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReason reason) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
    }

    /**
     * Type of the reason
     */
    public org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReasonType getType() {
        return type;
    }

    /**
     * Not restored reason
     */
    public org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReason getReason() {
        return reason;
    }

    private static BackForwardCacheNotRestoredExplanation fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReasonType type = null;
        org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReason reason = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReasonType.class);
                    break;
                case "reason":
                    reason = input.read(org.openqa.selenium.devtools.v100.page.model.BackForwardCacheNotRestoredReason.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BackForwardCacheNotRestoredExplanation(type, reason);
    }
}
