package org.openqa.selenium.devtools.v100.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when WebSocket handshake response becomes available.
 */
public class WebSocketHandshakeResponseReceived {

    private final org.openqa.selenium.devtools.v100.network.model.RequestId requestId;

    private final org.openqa.selenium.devtools.v100.network.model.MonotonicTime timestamp;

    private final org.openqa.selenium.devtools.v100.network.model.WebSocketResponse response;

    public WebSocketHandshakeResponseReceived(org.openqa.selenium.devtools.v100.network.model.RequestId requestId, org.openqa.selenium.devtools.v100.network.model.MonotonicTime timestamp, org.openqa.selenium.devtools.v100.network.model.WebSocketResponse response) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.response = java.util.Objects.requireNonNull(response, "response is required");
    }

    /**
     * Request identifier.
     */
    public org.openqa.selenium.devtools.v100.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Timestamp.
     */
    public org.openqa.selenium.devtools.v100.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    /**
     * WebSocket response data.
     */
    public org.openqa.selenium.devtools.v100.network.model.WebSocketResponse getResponse() {
        return response;
    }

    private static WebSocketHandshakeResponseReceived fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v100.network.model.RequestId requestId = null;
        org.openqa.selenium.devtools.v100.network.model.MonotonicTime timestamp = null;
        org.openqa.selenium.devtools.v100.network.model.WebSocketResponse response = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v100.network.model.RequestId.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v100.network.model.MonotonicTime.class);
                    break;
                case "response":
                    response = input.read(org.openqa.selenium.devtools.v100.network.model.WebSocketResponse.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WebSocketHandshakeResponseReceived(requestId, timestamp, response);
    }
}
