package org.openqa.selenium.devtools.v100.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SharedArrayBufferIssueType {

    TRANSFERISSUE("TransferIssue"), CREATIONISSUE("CreationIssue");

    private String value;

    SharedArrayBufferIssueType(String value) {
        this.value = value;
    }

    public static SharedArrayBufferIssueType fromString(String s) {
        return java.util.Arrays.stream(SharedArrayBufferIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SharedArrayBufferIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SharedArrayBufferIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
