/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v100.cachestorage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v100.cachestorage.model.Cache;
import org.openqa.selenium.devtools.v100.cachestorage.model.CacheId;
import org.openqa.selenium.devtools.v100.cachestorage.model.CachedResponse;
import org.openqa.selenium.devtools.v100.cachestorage.model.DataEntry;
import org.openqa.selenium.devtools.v100.cachestorage.model.Header;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CacheStorage {
    public static Command<Void> deleteCache(CacheId cacheId) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cacheId", (Object)cacheId);
        return new Command("CacheStorage.deleteCache", (Map)params.build());
    }

    public static Command<Void> deleteEntry(CacheId cacheId, String request) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(request, "request is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cacheId", (Object)cacheId);
        params.put((Object)"request", (Object)request);
        return new Command("CacheStorage.deleteEntry", (Map)params.build());
    }

    public static Command<List<Cache>> requestCacheNames(String securityOrigin) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        return new Command("CacheStorage.requestCacheNames", (Map)params.build(), ConverterFunctions.map((String)"caches", (Type)new TypeToken<List<Cache>>(){}.getType()));
    }

    public static Command<CachedResponse> requestCachedResponse(CacheId cacheId, String requestURL, List<Header> requestHeaders) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        Objects.requireNonNull(requestURL, "requestURL is required");
        Objects.requireNonNull(requestHeaders, "requestHeaders is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cacheId", (Object)cacheId);
        params.put((Object)"requestURL", (Object)requestURL);
        params.put((Object)"requestHeaders", requestHeaders);
        return new Command("CacheStorage.requestCachedResponse", (Map)params.build(), ConverterFunctions.map((String)"response", CachedResponse.class));
    }

    public static Command<RequestEntriesResponse> requestEntries(CacheId cacheId, Optional<Integer> skipCount, Optional<Integer> pageSize, Optional<String> pathFilter) {
        Objects.requireNonNull(cacheId, "cacheId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cacheId", (Object)cacheId);
        skipCount.ifPresent(p -> params.put((Object)"skipCount", p));
        pageSize.ifPresent(p -> params.put((Object)"pageSize", p));
        pathFilter.ifPresent(p -> params.put((Object)"pathFilter", p));
        return new Command("CacheStorage.requestEntries", (Map)params.build(), input -> (RequestEntriesResponse)input.read(RequestEntriesResponse.class));
    }

    public static class RequestEntriesResponse {
        private final List<DataEntry> cacheDataEntries;
        private final Number returnCount;

        public RequestEntriesResponse(List<DataEntry> cacheDataEntries, Number returnCount) {
            this.cacheDataEntries = Objects.requireNonNull(cacheDataEntries, "cacheDataEntries is required");
            this.returnCount = Objects.requireNonNull(returnCount, "returnCount is required");
        }

        public List<DataEntry> getCacheDataEntries() {
            return this.cacheDataEntries;
        }

        public Number getReturnCount() {
            return this.returnCount;
        }

        private static RequestEntriesResponse fromJson(JsonInput input) {
            List cacheDataEntries = null;
            Number returnCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "cacheDataEntries": {
                        cacheDataEntries = (List)input.read(new TypeToken<List<DataEntry>>(){}.getType());
                        continue block8;
                    }
                    case "returnCount": {
                        returnCount = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestEntriesResponse(cacheDataEntries, returnCount);
        }
    }
}

