/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v100.tracing.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v100.tracing.model.MemoryDumpConfig;
import org.openqa.selenium.json.JsonInput;

public class TraceConfig {
    private final Optional<RecordMode> recordMode;
    private final Optional<Boolean> enableSampling;
    private final Optional<Boolean> enableSystrace;
    private final Optional<Boolean> enableArgumentFilter;
    private final Optional<List<String>> includedCategories;
    private final Optional<List<String>> excludedCategories;
    private final Optional<List<String>> syntheticDelays;
    private final Optional<MemoryDumpConfig> memoryDumpConfig;

    public TraceConfig(Optional<RecordMode> recordMode, Optional<Boolean> enableSampling, Optional<Boolean> enableSystrace, Optional<Boolean> enableArgumentFilter, Optional<List<String>> includedCategories, Optional<List<String>> excludedCategories, Optional<List<String>> syntheticDelays, Optional<MemoryDumpConfig> memoryDumpConfig) {
        this.recordMode = recordMode;
        this.enableSampling = enableSampling;
        this.enableSystrace = enableSystrace;
        this.enableArgumentFilter = enableArgumentFilter;
        this.includedCategories = includedCategories;
        this.excludedCategories = excludedCategories;
        this.syntheticDelays = syntheticDelays;
        this.memoryDumpConfig = memoryDumpConfig;
    }

    public Optional<RecordMode> getRecordMode() {
        return this.recordMode;
    }

    public Optional<Boolean> getEnableSampling() {
        return this.enableSampling;
    }

    public Optional<Boolean> getEnableSystrace() {
        return this.enableSystrace;
    }

    public Optional<Boolean> getEnableArgumentFilter() {
        return this.enableArgumentFilter;
    }

    public Optional<List<String>> getIncludedCategories() {
        return this.includedCategories;
    }

    public Optional<List<String>> getExcludedCategories() {
        return this.excludedCategories;
    }

    public Optional<List<String>> getSyntheticDelays() {
        return this.syntheticDelays;
    }

    public Optional<MemoryDumpConfig> getMemoryDumpConfig() {
        return this.memoryDumpConfig;
    }

    private static TraceConfig fromJson(JsonInput input) {
        Optional<RecordMode> recordMode = Optional.empty();
        Optional<Boolean> enableSampling = Optional.empty();
        Optional<Boolean> enableSystrace = Optional.empty();
        Optional<Boolean> enableArgumentFilter = Optional.empty();
        Optional<List<String>> includedCategories = Optional.empty();
        Optional<List<String>> excludedCategories = Optional.empty();
        Optional<List<String>> syntheticDelays = Optional.empty();
        Optional<MemoryDumpConfig> memoryDumpConfig = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "recordMode": {
                    recordMode = Optional.ofNullable(RecordMode.fromString(input.nextString()));
                    continue block20;
                }
                case "enableSampling": {
                    enableSampling = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
                case "enableSystrace": {
                    enableSystrace = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
                case "enableArgumentFilter": {
                    enableArgumentFilter = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
                case "includedCategories": {
                    includedCategories = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block20;
                }
                case "excludedCategories": {
                    excludedCategories = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block20;
                }
                case "syntheticDelays": {
                    syntheticDelays = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block20;
                }
                case "memoryDumpConfig": {
                    memoryDumpConfig = Optional.ofNullable((MemoryDumpConfig)((Object)input.read(MemoryDumpConfig.class)));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TraceConfig(recordMode, enableSampling, enableSystrace, enableArgumentFilter, includedCategories, excludedCategories, syntheticDelays, memoryDumpConfig);
    }

    public static enum RecordMode {
        RECORDUNTILFULL("recordUntilFull"),
        RECORDCONTINUOUSLY("recordContinuously"),
        RECORDASMUCHASPOSSIBLE("recordAsMuchAsPossible"),
        ECHOTOCONSOLE("echoToConsole");

        private String value;

        private RecordMode(String value) {
            this.value = value;
        }

        public static RecordMode fromString(String s) {
            return Arrays.stream(RecordMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RecordMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RecordMode fromJson(JsonInput input) {
            return RecordMode.fromString(input.nextString());
        }
    }
}

