/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chromium.ChromiumDevToolsLocator;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.EventType;
import org.openqa.selenium.logging.HasLogEvents;
import org.openqa.selenium.mobile.NetworkConnection;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.mobile.RemoteNetworkConnection;

public class ChromiumDriver
extends RemoteWebDriver
implements HasAuthentication,
HasDevTools,
HasLogEvents,
HasTouchScreen,
LocationContext,
NetworkConnection,
WebStorage {
    private static final Logger LOG = Logger.getLogger(ChromiumDriver.class.getName());
    private final RemoteLocationContext locationContext = new RemoteLocationContext(this.getExecuteMethod());
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final TouchScreen touchScreen = new RemoteTouchScreen(this.getExecuteMethod());
    private final RemoteNetworkConnection networkConnection = new RemoteNetworkConnection(this.getExecuteMethod());
    private final Optional<Connection> connection;
    private final Optional<DevTools> devTools;

    protected ChromiumDriver(CommandExecutor commandExecutor, Capabilities capabilities, String capabilityKey) {
        super(commandExecutor, capabilities);
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        this.connection = ChromiumDevToolsLocator.getChromeConnector(factory, this.getCapabilities(), capabilityKey);
        CdpInfo cdpInfo = new CdpVersionFinder().match(this.getCapabilities().getBrowserVersion()).orElseGet(() -> {
            LOG.warning(String.format("Unable to find version of CDP to use for %s. You may need to include a dependency on a specific version of the CDP using something similar to `org.seleniumhq.selenium:selenium-devtools-v86:%s` where the version (\"v86\") matches the version of the chromium-based browser you're using and the version number of the artifact is the same as Selenium's.", capabilities.getBrowserVersion(), new BuildInfo().getReleaseLabel()));
            return new NoOpCdpInfo();
        });
        this.devTools = this.connection.map(conn -> new DevTools(arg_0 -> ((CdpInfo)cdpInfo).getDomains(arg_0), conn));
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> void onLogEvent(EventType<X> kind) {
        Require.nonNull((String)"Event type", kind);
        kind.initializeListener((HasLogEvents)this);
    }

    public void register(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        Require.nonNull((String)"Check to use to see how we should authenticate", whenThisMatches);
        Require.nonNull((String)"Credentials to use when authenticating", useTheseCredentials);
        this.getDevTools().createSessionIfThereIsNotOne();
        this.getDevTools().getDomains().network().addAuthHandler(whenThisMatches, useTheseCredentials);
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    public NetworkConnection.ConnectionType getNetworkConnection() {
        return this.networkConnection.getNetworkConnection();
    }

    public NetworkConnection.ConnectionType setNetworkConnection(NetworkConnection.ConnectionType type) {
        return this.networkConnection.setNetworkConnection(type);
    }

    public void launchApp(String id) {
        this.execute("launchApp", (Map)ImmutableMap.of((Object)"id", (Object)id));
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> parameters) {
        Require.nonNull((String)"Command name", (Object)commandName);
        Require.nonNull((String)"Parameters", parameters);
        Map toReturn = (Map)this.getExecuteMethod().execute("executeCdpCommand", (Map)ImmutableMap.of((Object)"cmd", (Object)commandName, (Object)"params", parameters));
        return ImmutableMap.copyOf((Map)toReturn);
    }

    public DevTools getDevTools() {
        return this.devTools.orElseThrow(() -> new WebDriverException("Unable to create DevTools connection"));
    }

    public String getCastSinks() {
        Object response = this.getExecuteMethod().execute("getCastSinks", null);
        return response.toString();
    }

    public String getCastIssueMessage() {
        Object response = this.getExecuteMethod().execute("getCastIssueMessage", null);
        return response.toString();
    }

    public void selectCastSink(String deviceName) {
        this.getExecuteMethod().execute("selectCastSink", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void startTabMirroring(String deviceName) {
        this.getExecuteMethod().execute("startCastTabMirroring", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void stopCasting(String deviceName) {
        this.getExecuteMethod().execute("stopCasting", (Map)ImmutableMap.of((Object)"sinkName", (Object)deviceName));
    }

    public void setPermission(String name, String value) {
        this.getExecuteMethod().execute("setPermission", (Map)ImmutableMap.of((Object)"descriptor", (Object)ImmutableMap.of((Object)"name", (Object)name), (Object)"state", (Object)value));
    }

    public void quit() {
        this.connection.ifPresent(Connection::close);
        super.quit();
    }
}

