/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_APPEND_LOG_PROPERTY = "webdriver.chrome.appendLog";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.chrome.silentOutput";
    public static final String CHROME_DRIVER_WHITELISTED_IPS_PROPERTY = "webdriver.chrome.whitelistedIps";

    public ChromeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public ChromeDriverService(File executable, int port, Duration timeout, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static ChromeDriverService createDefaultService() {
        return (ChromeDriverService)new Builder().build();
    }

    public static class Builder
    extends DriverService.Builder<ChromeDriverService, Builder> {
        private boolean appendLog = Boolean.getBoolean("webdriver.chrome.appendLog");
        private boolean verbose = Boolean.getBoolean("webdriver.chrome.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.chrome.silentOutput");
        private String whitelistedIps = System.getProperty("webdriver.chrome.whitelistedIps");

        public int score(Capabilities capabilities) {
            int score = 0;
            if ("chrome".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("goog:chromeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = appendLog;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder withWhitelistedIps(String whitelistedIps) {
            this.whitelistedIps = whitelistedIps;
            return this;
        }

        protected File findDefaultExecutable() {
            return ChromeDriverService.findExecutable((String)"chromedriver", (String)ChromeDriverService.CHROME_DRIVER_EXE_PROPERTY, (String)"https://github.com/SeleniumHQ/selenium/wiki/ChromeDriver", (String)"http://chromedriver.storage.googleapis.com/index.html");
        }

        protected ImmutableList<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(ChromeDriverService.CHROME_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add((Object)String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.appendLog) {
                argsBuilder.add((Object)"--append-log");
            }
            if (this.verbose) {
                argsBuilder.add((Object)"--verbose");
            }
            if (this.silent) {
                argsBuilder.add((Object)"--silent");
            }
            if (this.whitelistedIps != null) {
                argsBuilder.add((Object)String.format("--whitelisted-ips=%s", this.whitelistedIps));
            }
            return argsBuilder.build();
        }

        protected ChromeDriverService createDriverService(File exe, int port, Duration timeout, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new ChromeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

