/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.io.TemporaryFilesystem;

public class ChromeProfile {
    public static final ChromeProfile DEFAULT_PROFILE = new ChromeProfile(new File("WEBDRIVER_DEFAULT_PROFILE"));
    private static final String REAP_PROFILE_PROPERTY = "webdriver.reap_profile";
    private final File directory;
    private Proxy proxy;
    private boolean acceptUntrustedCerts;

    public ChromeProfile(File directory) {
        this.directory = directory;
        this.acceptUntrustedCerts = true;
    }

    public ChromeProfile() {
        this(ChromeProfile.createProfileDir());
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedSsl) {
        this.acceptUntrustedCerts = acceptUntrustedSsl;
    }

    public String getUntrustedCertificatesFlag() {
        return this.acceptUntrustedCerts ? "--ignore-certificate-errors" : "";
    }

    public File getDirectory() {
        return this.directory;
    }

    private static File createProfileDir() {
        File tempProfileDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("profile", "");
        System.setProperty(REAP_PROFILE_PROPERTY, "false");
        return tempProfileDir;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChromeProfile)) {
            return false;
        }
        ChromeProfile other = (ChromeProfile)obj;
        if (this.directory == null && other.directory != null || this.directory != null && !this.directory.equals(other.directory)) {
            return false;
        }
        return (this.proxy != null || other.proxy == null) && (this.proxy == null || this.proxy.equals(other.proxy));
    }
}

