/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class ChromeProfile {
    private static final String REAP_PROFILE_PROPERTY = "webdriver.reap_profile";
    private static final String FIRST_RUN_FILE_NAME = "First Run Dev";
    private final File directory;

    public ChromeProfile(File directory) {
        this.directory = directory;
    }

    public ChromeProfile() {
        this(ChromeProfile.createProfileDir());
    }

    public File getDirectory() {
        return this.directory;
    }

    private static File createProfileDir() {
        try {
            File tempProfileDir = TemporaryFilesystem.createTempDir((String)"profile", (String)"");
            File firstRunFile = new File(tempProfileDir, FIRST_RUN_FILE_NAME);
            firstRunFile.createNewFile();
            System.setProperty(REAP_PROFILE_PROPERTY, "false");
            return tempProfileDir;
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

