/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.net.HostIdentifier;

public class WebDriverException
extends RuntimeException {
    public static final String SESSION_ID = "Session ID";
    public static final String DRIVER_INFO = "Driver info";
    protected static final String BASE_SUPPORT_URL = "https://selenium.dev/exceptions/";
    private final Map<String, String> extraInfo = new ConcurrentHashMap<String, String>();

    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return this.getCause() instanceof WebDriverException ? super.getMessage() : this.createMessage(super.getMessage());
    }

    public String getRawMessage() {
        return super.getMessage();
    }

    private String createMessage(String originalMessageString) {
        String supportMessage = Optional.ofNullable(this.getSupportUrl()).map(url -> String.format("For documentation on this error, please visit: %s", url)).orElse("");
        return Stream.of(originalMessageString == null ? "" : originalMessageString, supportMessage, this.getBuildInformation().toString(), this.getSystemInformation(), this.getAdditionalInformation()).filter(s -> s != null && !s.equals("")).collect(Collectors.joining("\n"));
    }

    public String getSystemInformation() {
        return String.format("System info: os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public static String getHostInformation() {
        return String.format("Host info: host: '%s', ip: '%s'", HostIdentifier.getHostName(), HostIdentifier.getHostAddress());
    }

    public String getSupportUrl() {
        return null;
    }

    public BuildInfo getBuildInformation() {
        return new BuildInfo();
    }

    public static String getDriverName(StackTraceElement[] stackTraceElements) {
        return Stream.of(stackTraceElements).filter(e -> e.getClassName().endsWith("Driver")).map(e -> {
            String[] bits = e.getClassName().split("\\.");
            return bits[bits.length - 1];
        }).reduce((first, last) -> last).orElse("unknown");
    }

    public void addInfo(String key, String value) {
        this.extraInfo.put(key, value);
    }

    public String getAdditionalInformation() {
        this.extraInfo.computeIfAbsent(DRIVER_INFO, key -> "driver.version: " + WebDriverException.getDriverName(this.getStackTrace()));
        return this.extraInfo.entrySet().stream().map(entry -> entry.getValue() != null && ((String)entry.getValue()).startsWith((String)entry.getKey()) ? (String)entry.getValue() : (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\n"));
    }
}

