/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class UrlChecker {
    private static final Logger log = Logger.getLogger(UrlChecker.class.getName());
    static final int CONNECT_TIMEOUT_MS = 500;
    private static final int READ_TIMEOUT_MS = 1000;
    private static final long MAX_POLL_INTERVAL_MS = 320L;
    private static final long MIN_POLL_INTERVAL_MS = 10L;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(1);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "UrlChecker-" + THREAD_COUNTER.incrementAndGet());
        t.setDaemon(true);
        return t;
    });

    public void waitUntilAvailable(long timeout, TimeUnit unit, URL ... urls) throws TimeoutException {
        long start = System.nanoTime();
        log.fine("Waiting for " + Arrays.toString(urls));
        try {
            Future<Void> callback = EXECUTOR.submit(() -> {
                HttpURLConnection connection = null;
                long sleepMillis = 10L;
                while (true) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    for (URL url : urls) {
                        try {
                            log.fine("Polling " + url);
                            connection = this.connectToUrl(url);
                            if (connection.getResponseCode() != 200) continue;
                            Void void_ = null;
                            return void_;
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (connection != null) {
                                connection.disconnect();
                            }
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    sleepMillis = sleepMillis >= 320L ? sleepMillis : sleepMillis * 2L;
                }
            });
            callback.get(timeout, unit);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Timed out waiting for %s to be available after %d ms", Arrays.toString(urls), TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilUnavailable(long timeout, TimeUnit unit, URL url) throws TimeoutException {
        long start = System.nanoTime();
        log.fine("Waiting for " + url);
        try {
            Future<Void> callback = EXECUTOR.submit(() -> {
                HttpURLConnection connection = null;
                long sleepMillis = 10L;
                while (true) {
                    try {
                        log.fine("Polling " + url);
                        connection = this.connectToUrl(url);
                        if (connection.getResponseCode() != 200) {
                            Void void_ = null;
                            return void_;
                        }
                    }
                    catch (IOException e) {
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    sleepMillis = sleepMillis >= 320L ? sleepMillis : sleepMillis * 2L;
                }
            });
            callback.get(timeout, unit);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Timed out waiting for %s to become unavailable after %d ms", url, TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)), e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpURLConnection connectToUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(500);
        connection.setReadTimeout(1000);
        connection.connect();
        return connection;
    }

    public static class TimeoutException
    extends Exception {
        public TimeoutException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

