/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.logging.Logs;

public interface WebDriver
extends SearchContext {
    public void get(String var1);

    public String getCurrentUrl();

    public String getTitle();

    @Override
    public List<WebElement> findElements(By var1);

    @Override
    public WebElement findElement(By var1);

    public String getPageSource();

    public void close();

    public void quit();

    public Set<String> getWindowHandles();

    public String getWindowHandle();

    public TargetLocator switchTo();

    public Navigation navigate();

    public Options manage();

    @Beta
    public static interface Window {
        public Dimension getSize();

        public void setSize(Dimension var1);

        public Point getPosition();

        public void setPosition(Point var1);

        public void maximize();

        public void minimize();

        public void fullscreen();
    }

    public static interface ImeHandler {
        public List<String> getAvailableEngines();

        public String getActiveEngine();

        public boolean isActivated();

        public void deactivate();

        public void activateEngine(String var1);
    }

    public static interface Navigation {
        public void back();

        public void forward();

        public void to(String var1);

        public void to(URL var1);

        public void refresh();
    }

    public static interface TargetLocator {
        public WebDriver frame(int var1);

        public WebDriver frame(String var1);

        public WebDriver frame(WebElement var1);

        public WebDriver parentFrame();

        public WebDriver window(String var1);

        public WebDriver newWindow(WindowType var1);

        public WebDriver defaultContent();

        public WebElement activeElement();

        public Alert alert();
    }

    public static interface Timeouts {
        @Deprecated
        public Timeouts implicitlyWait(long var1, TimeUnit var3);

        default public Timeouts implicitlyWait(Duration duration) {
            return this.implicitlyWait(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        default public Duration getImplicitWaitTimeout() {
            throw new UnsupportedCommandException();
        }

        @Deprecated
        public Timeouts setScriptTimeout(long var1, TimeUnit var3);

        default public Timeouts setScriptTimeout(Duration duration) {
            return this.setScriptTimeout(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        default public Duration getScriptTimeout() {
            throw new UnsupportedCommandException();
        }

        @Deprecated
        public Timeouts pageLoadTimeout(long var1, TimeUnit var3);

        default public Timeouts pageLoadTimeout(Duration duration) {
            return this.pageLoadTimeout(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        default public Duration getPageLoadTimeout() {
            throw new UnsupportedCommandException();
        }
    }

    public static interface Options {
        public void addCookie(Cookie var1);

        public void deleteCookieNamed(String var1);

        public void deleteCookie(Cookie var1);

        public void deleteAllCookies();

        public Set<Cookie> getCookies();

        public Cookie getCookieNamed(String var1);

        public Timeouts timeouts();

        public ImeHandler ime();

        public Window window();

        @Beta
        public Logs logs();
    }
}

