/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;

public interface Capabilities {
    default public String getBrowserName() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserName")).orElse(""));
    }

    default public Platform getPlatform() {
        Object rawPlatform = this.getCapability("platformName");
        if (rawPlatform == null) {
            rawPlatform = this.getCapability("platform");
        }
        if (rawPlatform == null) {
            return null;
        }
        if (rawPlatform instanceof String) {
            return Platform.fromString((String)rawPlatform);
        }
        if (rawPlatform instanceof Platform) {
            return (Platform)((Object)rawPlatform);
        }
        throw new IllegalStateException("Platform was neither a string nor a Platform: " + rawPlatform);
    }

    default public String getVersion() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserVersion")).orElse(Optional.ofNullable(this.getCapability("version")).orElse("")));
    }

    public Map<String, Object> asMap();

    public Object getCapability(String var1);

    default public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return "javascriptEnabled".equals(capabilityName);
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    default public Capabilities merge(Capabilities other) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.asMap());
        if (other != null) {
            map.putAll(other.asMap());
        }
        return new ImmutableCapabilities(map);
    }

    default public Set<String> getCapabilityNames() {
        return Collections.unmodifiableSet(this.asMap().keySet());
    }
}

