/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions.internal;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.IsInteraction;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.internal.BaseAction;
import org.openqa.selenium.interactions.internal.Locatable;

public abstract class KeysRelatedAction
extends BaseAction
implements IsInteraction {
    protected final Keyboard keyboard;
    protected final Mouse mouse;

    protected KeysRelatedAction(Keyboard keyboard, Mouse mouse, Locatable locationProvider) {
        super(locationProvider);
        this.keyboard = keyboard;
        this.mouse = mouse;
    }

    protected void focusOnElement() {
        if (this.where != null) {
            this.mouse.click(this.where.getCoordinates());
        }
    }

    protected Collection<Interaction> optionallyClickElement(PointerInput mouse) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        Optional<WebElement> target = this.getTargetElement();
        if (target.isPresent()) {
            interactions.add(mouse.createPointerMove(Duration.ofMillis(500L), target.map(PointerInput.Origin::fromElement).orElse(PointerInput.Origin.pointer()), 0, 0));
            interactions.add(mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            interactions.add(mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        }
        return Collections.unmodifiableList(interactions);
    }
}

