/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;

public abstract class By {
    public static By id(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot find elements with a null id attribute.");
        }
        return new ById(id);
    }

    public static By linkText(String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException("Cannot find elements when link text is null.");
        }
        return new ByLinkText(linkText);
    }

    public static By partialLinkText(String linkText) {
        if (linkText == null) {
            throw new IllegalArgumentException("Cannot find elements when link text is null.");
        }
        return new ByPartialLinkText(linkText);
    }

    public static By name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when name text is null.");
        }
        return new ByName(name);
    }

    public static By tagName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find elements when name tag name is null.");
        }
        return new ByTagName(name);
    }

    public static By xpath(String xpathExpression) {
        if (xpathExpression == null) {
            throw new IllegalArgumentException("Cannot find elements when the XPath expression is null.");
        }
        return new ByXPath(xpathExpression);
    }

    public static By className(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (className.matches(".*\\s+.*")) {
            throw new InvalidSelectorException("Compound class names are not supported. Consider searching for one class name and filtering the results or use CSS selectors.");
        }
        return new ByClassName(className);
    }

    public static By cssSelector(String selector) {
        if (selector == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        return new ByCssSelector(selector);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        By by = (By)o;
        return this.toString().equals(by.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[unknown locator]";
    }

    public static class ByCssSelector
    extends By
    implements Serializable {
        private static final long serialVersionUID = -3910258723099459239L;
        private final String selector;

        public ByCssSelector(String selector) {
            this.selector = selector;
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByCssSelector) {
                return ((FindsByCssSelector)((Object)context)).findElementByCssSelector(this.selector);
            }
            throw new WebDriverException("Driver does not support finding an element by selector: " + this.selector);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByCssSelector) {
                return ((FindsByCssSelector)((Object)context)).findElementsByCssSelector(this.selector);
            }
            throw new WebDriverException("Driver does not support finding elements by selector: " + this.selector);
        }

        @Override
        public String toString() {
            return "By.selector: " + this.selector;
        }
    }

    public static class ByClassName
    extends By
    implements Serializable {
        private static final long serialVersionUID = -8737882849130394673L;
        private final String className;

        public ByClassName(String className) {
            this.className = className;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)((Object)context)).findElementsByClassName(this.className);
            }
            return ((FindsByXPath)((Object)context)).findElementsByXPath(".//*[" + this.containingWord("class", this.className) + "]");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)((Object)context)).findElementByClassName(this.className);
            }
            return ((FindsByXPath)((Object)context)).findElementByXPath(".//*[" + this.containingWord("class", this.className) + "]");
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        @Override
        public String toString() {
            return "By.className: " + this.className;
        }
    }

    public static class ByXPath
    extends By
    implements Serializable {
        private static final long serialVersionUID = -6727228887685051584L;
        private final String xpathExpression;

        public ByXPath(String xpathExpression) {
            this.xpathExpression = xpathExpression;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByXPath)((Object)context)).findElementsByXPath(this.xpathExpression);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByXPath)((Object)context)).findElementByXPath(this.xpathExpression);
        }

        @Override
        public String toString() {
            return "By.xpath: " + this.xpathExpression;
        }
    }

    public static class ByTagName
    extends By
    implements Serializable {
        private static final long serialVersionUID = 4699295846984948351L;
        private final String name;

        public ByTagName(String name) {
            this.name = name;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByTagName) {
                return ((FindsByTagName)((Object)context)).findElementsByTagName(this.name);
            }
            return ((FindsByXPath)((Object)context)).findElementsByXPath(".//" + this.name);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByTagName) {
                return ((FindsByTagName)((Object)context)).findElementByTagName(this.name);
            }
            return ((FindsByXPath)((Object)context)).findElementByXPath(".//" + this.name);
        }

        @Override
        public String toString() {
            return "By.tagName: " + this.name;
        }
    }

    public static class ByName
    extends By
    implements Serializable {
        private static final long serialVersionUID = 376317282960469555L;
        private final String name;

        public ByName(String name) {
            this.name = name;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByName) {
                return ((FindsByName)((Object)context)).findElementsByName(this.name);
            }
            return ((FindsByXPath)((Object)context)).findElementsByXPath(".//*[@name = '" + this.name + "']");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByName) {
                return ((FindsByName)((Object)context)).findElementByName(this.name);
            }
            return ((FindsByXPath)((Object)context)).findElementByXPath(".//*[@name = '" + this.name + "']");
        }

        @Override
        public String toString() {
            return "By.name: " + this.name;
        }
    }

    public static class ByPartialLinkText
    extends By
    implements Serializable {
        private static final long serialVersionUID = 1163955344140679054L;
        private final String linkText;

        public ByPartialLinkText(String linkText) {
            this.linkText = linkText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByLinkText)((Object)context)).findElementsByPartialLinkText(this.linkText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByLinkText)((Object)context)).findElementByPartialLinkText(this.linkText);
        }

        @Override
        public String toString() {
            return "By.partialLinkText: " + this.linkText;
        }
    }

    public static class ByLinkText
    extends By
    implements Serializable {
        private static final long serialVersionUID = 1967414585359739708L;
        private final String linkText;

        public ByLinkText(String linkText) {
            this.linkText = linkText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByLinkText)((Object)context)).findElementsByLinkText(this.linkText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByLinkText)((Object)context)).findElementByLinkText(this.linkText);
        }

        @Override
        public String toString() {
            return "By.linkText: " + this.linkText;
        }
    }

    public static class ById
    extends By
    implements Serializable {
        private static final long serialVersionUID = 5341968046120372169L;
        private final String id;

        public ById(String id) {
            this.id = id;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsById) {
                return ((FindsById)((Object)context)).findElementsById(this.id);
            }
            return ((FindsByXPath)((Object)context)).findElementsByXPath(".//*[@id = '" + this.id + "']");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsById) {
                return ((FindsById)((Object)context)).findElementById(this.id);
            }
            return ((FindsByXPath)((Object)context)).findElementByXPath(".//*[@id = '" + this.id + "']");
        }

        @Override
        public String toString() {
            return "By.id: " + this.id;
        }
    }
}

