/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.htmlunit.ScriptException;
import org.htmlunit.ScriptResult;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;

class AsyncScriptExecutor {
    private final HtmlPage page_;
    private final long timeoutMillis_;
    private AsyncScriptResult asyncResult_;

    AsyncScriptExecutor(HtmlPage page, long timeoutMillis) {
        this.page_ = page;
        this.timeoutMillis_ = timeoutMillis;
    }

    void alertTriggered(String message) {
        this.asyncResult_.alert(message);
    }

    public Object execute(String scriptBody, Object[] parameters) {
        try {
            this.asyncResult_ = new AsyncScriptResult();
            Function function = this.createInjectedScriptFunction(scriptBody, this.asyncResult_);
            try {
                this.page_.executeJavaScriptFunction((Object)function, (Object)function, parameters, (DomNode)this.page_.getDocumentElement());
            }
            catch (ScriptException e) {
                throw new WebDriverException((Throwable)e);
            }
            try {
                Object object = this.asyncResult_.waitForResult(this.timeoutMillis_);
                return object;
            }
            catch (InterruptedException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        finally {
            this.asyncResult_ = null;
        }
    }

    private Function createInjectedScriptFunction(String userScript, AsyncScriptResult asyncResult) {
        String script = "function() {  var self = this, timeoutId;  var cleanUp = function() {    window.clearTimeout(timeoutId);    if (window.detachEvent) {      window.detachEvent('onunload', catchUnload);    } else {      window.removeEventListener('unload', catchUnload, false);    }  };  var self = this, timeoutId, catchUnload = function() {    cleanUp();    self.host.unload();  };  arguments = Array.prototype.slice.call(arguments, 0);  arguments.push(function(value) {    cleanUp();    self.host.callback(typeof value == 'undefined' ? null : value);  });  if (window.attachEvent) {    window.attachEvent('onunload', catchUnload);  } else {    window.addEventListener('unload', catchUnload, false);  }  (function() {" + userScript + "}).apply(null, arguments);" + "  timeoutId = window.setTimeout(function() {" + "    self.host.timeout();" + "  }, " + this.timeoutMillis_ + ");" + "}";
        ScriptResult result = this.page_.executeJavaScript(script);
        Function function = (Function)result.getJavaScriptResult();
        function.put("host", (Scriptable)function, (Object)new NativeJavaObject((Scriptable)function, (Object)asyncResult, null));
        return function;
    }

    public static class AsyncScriptResult {
        private final CountDownLatch latch_ = new CountDownLatch(1);
        private volatile Object value_;
        private volatile boolean isTimeout_;
        private volatile String alertMessage_;
        private volatile boolean unloadDetected_;

        Object waitForResult(long timeoutMillis) throws InterruptedException {
            long startTimeNanos = System.nanoTime();
            this.latch_.await();
            if (this.isTimeout_) {
                long elapsedTimeNanos = System.nanoTime() - startTimeNanos;
                long elapsedTimeMillis = TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos);
                throw new ScriptTimeoutException("Timed out waiting for async script result after " + elapsedTimeMillis + "ms");
            }
            if (this.alertMessage_ != null) {
                throw new UnhandledAlertException("Alert found", this.alertMessage_);
            }
            if (this.unloadDetected_) {
                throw new WebDriverException("Detected a page unload event; executeAsyncScript does not work across page loads");
            }
            return this.value_;
        }

        public void callback(Object callbackValue) {
            if (this.latch_.getCount() > 0L) {
                this.value_ = callbackValue;
                this.latch_.countDown();
            }
        }

        public void timeout() {
            if (this.latch_.getCount() > 0L) {
                this.isTimeout_ = true;
                this.latch_.countDown();
            }
        }

        private void alert(String message) {
            if (this.latch_.getCount() > 0L) {
                this.alertMessage_ = message;
                this.latch_.countDown();
            }
        }

        public void unload() {
            if (this.latch_.getCount() > 0L) {
                this.unloadDetected_ = true;
                this.latch_.countDown();
            }
        }
    }
}

