/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class HtmlUnitAlert
implements Alert {
    private HtmlUnitDriver driver_;
    private AlertHolder holder_;
    private boolean quitting_;
    private Lock lock_ = new ReentrantLock();
    private Condition condition_ = this.lock_.newCondition();
    private WebWindow webWindow_;
    private UnexpectedAlertBehaviour unexpectedAlertBehaviour_ = UnexpectedAlertBehaviour.DISMISS_AND_NOTIFY;

    HtmlUnitAlert(HtmlUnitDriver driver) {
        this.driver_ = driver;
        WebClient webClient = driver.getWebClient();
        webClient.setAlertHandler(this::alertHandler);
        webClient.setPromptHandler(this::promptHandler);
        webClient.setConfirmHandler(this::confirmHandler);
        webClient.setOnbeforeunloadHandler(this::onbeforeunloadHandler);
    }

    private void alertHandler(Page page, String message) {
        if (this.quitting_) {
            return;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new AlertHolder(message);
        this.awaitCondition();
    }

    private boolean confirmHandler(Page page, String message) {
        if (this.quitting_) {
            return false;
        }
        this.webWindow_ = page.getEnclosingWindow();
        AlertHolder localHolder = this.holder_ = new AlertHolder(message);
        this.awaitCondition();
        return localHolder.isAccepted();
    }

    private void awaitCondition() {
        block5: {
            this.lock_.lock();
            try {
                if (!this.driver_.isProcessAlert()) break block5;
                try {
                    this.condition_.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.lock_.unlock();
            }
        }
    }

    private String promptHandler(Page page, String message, String defaultMessage) {
        if (this.quitting_) {
            return null;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new PromptHolder(message, defaultMessage);
        PromptHolder localHolder = (PromptHolder)this.holder_;
        this.awaitCondition();
        return localHolder.value_;
    }

    private boolean onbeforeunloadHandler(Page page, String returnValue) {
        if (this.quitting_) {
            return true;
        }
        this.webWindow_ = page.getEnclosingWindow();
        AlertHolder localHolder = this.holder_ = new AlertHolder(returnValue);
        this.awaitCondition();
        return localHolder.isAccepted();
    }

    WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.quitting_ = autoAccept;
    }

    public void handleBrowserCapabilities(Capabilities capabilities) {
        UnexpectedAlertBehaviour behaviour = (UnexpectedAlertBehaviour)capabilities.getCapability("unexpectedAlertBehaviour");
        if (behaviour != null) {
            this.unexpectedAlertBehaviour_ = behaviour;
        }
    }

    public void dismiss() {
        this.lock_.lock();
        try {
            this.condition_.signal();
        }
        finally {
            this.lock_.unlock();
            this.holder_ = null;
        }
    }

    public void accept() {
        this.lock_.lock();
        try {
            this.holder_.accept();
            this.condition_.signal();
        }
        finally {
            this.lock_.unlock();
            this.holder_ = null;
        }
    }

    public String getText() {
        if (this.holder_ == null) {
            throw new NoAlertPresentException();
        }
        String msg = this.holder_.message_;
        msg = msg.replace("\r\n", "\n");
        if (!this.driver_.getBrowserVersion().isIE()) {
            msg = msg.replace('\r', '\n');
        }
        return msg;
    }

    public void sendKeys(String keysToSend) {
        this.holder_.sendKeys(keysToSend);
    }

    void close() {
        this.lock_.lock();
        try {
            this.condition_.signal();
            this.setAutoAccept(true);
        }
        finally {
            this.lock_.unlock();
            this.holder_ = null;
        }
    }

    boolean isLocked() {
        return this.holder_ != null;
    }

    public void ensureUnlocked() {
        if (this.isLocked()) {
            String text = this.getText();
            switch (this.unexpectedAlertBehaviour_) {
                case ACCEPT: {
                    this.accept();
                    return;
                }
                case ACCEPT_AND_NOTIFY: {
                    this.accept();
                    break;
                }
                case DISMISS: {
                    this.dismiss();
                    return;
                }
                case DISMISS_AND_NOTIFY: {
                    this.dismiss();
                    break;
                }
                case IGNORE: {
                    break;
                }
            }
            throw new UnhandledAlertException("Unexpected alert found", text);
        }
    }

    private static class PromptHolder
    extends AlertHolder {
        private final String defaultMessage_;
        private String value_;

        PromptHolder(String message, String defaultMessage) {
            super(message);
            this.defaultMessage_ = defaultMessage;
        }

        @Override
        void sendKeys(String keysToSend) {
            if (keysToSend == null) {
                keysToSend = this.defaultMessage_;
            }
            this.value_ = keysToSend;
        }

        @Override
        void accept() {
            if (this.value_ == null) {
                this.value_ = this.defaultMessage_;
            }
        }
    }

    private static class AlertHolder {
        private String message_;
        private boolean accepted_;

        AlertHolder(String message) {
            this.message_ = message;
        }

        void sendKeys(String keysToSend) {
            if (keysToSend != null) {
                throw new ElementNotInteractableException("alert is not interactable");
            }
            throw new IllegalArgumentException();
        }

        void accept() {
            this.accepted_ = true;
        }

        boolean isAccepted() {
            return this.accepted_;
        }
    }
}

