/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.local;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.Span;

public class LocalSessionMap
extends SessionMap {
    private final DistributedTracer tracer;
    private final EventBus bus;
    private final Map<SessionId, Session> knownSessions = new HashMap<SessionId, Session>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public LocalSessionMap(DistributedTracer tracer, EventBus bus) {
        this.tracer = Objects.requireNonNull(tracer);
        this.bus = Objects.requireNonNull(bus);
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            SessionId id = (SessionId)event.getData((Type)((Object)SessionId.class));
            this.knownSessions.remove(id);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Session session) {
        Objects.requireNonNull(session, "Session has not been set");
        try (Span span = this.tracer.createSpan("sessionmap.add", this.tracer.getActiveSpan());){
            span.addTag("session.id", (Object)session.getId());
            span.addTag("session.capabilities", (Object)session.getCapabilities());
            span.addTag("session.uri", (Object)session.getUri());
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.knownSessions.put(session.getId(), session);
            }
            finally {
                writeLock.unlock();
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session get(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        Throwable throwable = null;
        try (Span span = this.tracer.createSpan("sessionmap.get", this.tracer.getActiveSpan());){
            span.addTag("session.id", (Object)id);
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                Session session = this.knownSessions.get(id);
                if (session == null) {
                    throw new NoSuchSessionException("Unable to find session with ID: " + id);
                }
                span.addTag("session.capabilities", (Object)session.getCapabilities());
                span.addTag("session.uri", (Object)session.getUri());
                Session session2 = session;
                readLock.unlock();
                return session2;
            }
            catch (Throwable throwable2) {
                try {
                    readLock.unlock();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        try (Span span = this.tracer.createSpan("sessionmap.remove", this.tracer.getActiveSpan());){
            span.addTag("session.id", (Object)id);
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.knownSessions.remove(id);
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

