/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.AddNode;
import org.openqa.selenium.grid.distributor.CreateSession;
import org.openqa.selenium.grid.distributor.GetDistributorStatus;
import org.openqa.selenium.grid.distributor.RemoveNode;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.HandlerNotFoundException;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public abstract class Distributor
implements Predicate<HttpRequest>,
CommandHandler {
    private final Routes routes;

    protected Distributor(DistributedTracer tracer, HttpClient.Factory httpClientFactory) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(httpClientFactory);
        Json json = new Json();
        this.routes = Routes.combine(Routes.post("/session").using((req, res) -> {
            CreateSessionResponse sessionResponse = this.newSession(req);
            res.setContent(Contents.bytes((byte[])sessionResponse.getDownstreamEncodedResponse()));
        }), Routes.post("/se/grid/distributor/session").using(() -> new CreateSession(json, this)), Routes.post("/se/grid/distributor/node").using(() -> new AddNode(tracer, this, json, httpClientFactory)), Routes.delete("/se/grid/distributor/node/{nodeId}").using(params -> new RemoveNode(this, UUID.fromString((String)params.get("nodeId")))), Routes.get("/se/grid/distributor/status").using(() -> new GetDistributorStatus(json, this))).build();
    }

    public abstract CreateSessionResponse newSession(HttpRequest var1) throws SessionNotCreatedException;

    public abstract Distributor add(Node var1);

    public abstract void remove(UUID var1);

    public abstract DistributorStatus getStatus();

    @Override
    public boolean test(HttpRequest req) {
        return this.routes.match(req).isPresent();
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Optional<CommandHandler> handler = this.routes.match(req);
        if (!handler.isPresent()) {
            throw new HandlerNotFoundException(req);
        }
        handler.get().execute(req, resp);
    }
}

