/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.By;
import org.seleniumhq.selenium.fluent.internal.ContextElem;

public class Context
implements Iterable<ContextElem> {
    private List<ContextElem> elems = new ArrayList<ContextElem>();

    @Override
    public Iterator<ContextElem> iterator() {
        return Collections.unmodifiableList(this.elems).iterator();
    }

    public static Context singular(Context previous, String tagName, By by) {
        return Context.make(previous, tagName, by, null);
    }

    private static Context make(Context previous, String tagName, By by, Object arg) {
        Context ctx = new Context();
        if (previous != null) {
            ctx.elems.addAll(previous.elems);
        }
        ctx.elems.add(new ContextElem(tagName, by, arg));
        return ctx;
    }

    public static Context plural(Context previous, String tagName, By by) {
        return Context.make(previous, tagName + "s", by, null);
    }

    public static Context singular(Context previous, String tagName) {
        return Context.make(previous, tagName, null, null);
    }

    public static Context singular(Context context, String tagName, Object arg) {
        return Context.make(context, tagName, null, arg);
    }

    public static Context singular(Context previous, String tagName, By by, Object arg) {
        return Context.make(previous, tagName, by, arg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("?");
        for (ContextElem elem : this.elems) {
            sb.append(elem.toString());
        }
        return sb.toString();
    }
}

