/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse.eval;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.parse.Tokens;
import org.scijava.parse.eval.DefaultEvaluator;
import org.scijava.parse.eval.Evaluator;
import org.scijava.parse.eval.Unresolved;

public class EvaluatorConsole {
    private static final String PROMPT = "> ";
    private final Evaluator evaluator;

    public EvaluatorConsole() {
        this(new DefaultEvaluator());
    }

    public EvaluatorConsole(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void showConsole() throws IOException {
        this.showConsole(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void showConsole(BufferedReader in) throws IOException {
        while (true) {
            this.print(PROMPT);
            String line = in.readLine();
            if (line == null) break;
            try {
                Object result = this.evaluator.evaluate(line);
                this.evaluator.setStrict(false);
                if (result == null) continue;
                this.printResult(result);
            }
            catch (IllegalArgumentException exc) {
                String msg = exc.getMessage();
                if (msg == null) {
                    throw exc;
                }
                Matcher m = Pattern.compile(".* at index (\\d+)").matcher(msg);
                if (m.matches()) {
                    int index = Integer.parseInt(m.group(1));
                    this.println(this.caret(index));
                }
                this.println(msg);
            }
        }
    }

    private void printResult(Object o) {
        if (o instanceof List) {
            for (Object item : (List)o) {
                this.printResult(item);
            }
        } else if (Tokens.isVariable(o)) {
            Object value = this.evaluator.value(o);
            if (value instanceof Unresolved) {
                this.println(this.valueAndType(o));
            } else {
                this.println(this.valueAndType(o) + " = " + this.valueAndType(value));
            }
        } else {
            this.println(this.valueAndType(o));
        }
    }

    private String valueAndType(Object o) {
        return o + " : " + o.getClass().getName();
    }

    private void print(Object o) {
        System.out.print(o);
    }

    private void println(Object o) {
        System.out.println(o);
    }

    private String caret(int index) {
        StringBuilder sb = new StringBuilder();
        int count = PROMPT.length() + index;
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }
}

