/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.ffi;

import java.nio.ByteOrder;
import org.scijava.jython.shaded.jnr.ffi.NativeType;
import org.scijava.jython.shaded.jnr.ffi.ObjectReferenceManager;
import org.scijava.jython.shaded.jnr.ffi.Type;
import org.scijava.jython.shaded.jnr.ffi.TypeAlias;
import org.scijava.jython.shaded.jnr.ffi.provider.ClosureManager;
import org.scijava.jython.shaded.jnr.ffi.provider.FFIProvider;
import org.scijava.jython.shaded.jnr.ffi.provider.LoadedLibrary;
import org.scijava.jython.shaded.jnr.ffi.provider.MemoryManager;

public abstract class Runtime {
    public static Runtime getSystemRuntime() {
        return SingletonHolder.SYSTEM_RUNTIME;
    }

    public static Runtime getRuntime(Object library) {
        return ((LoadedLibrary)library).getRuntime();
    }

    public abstract Type findType(NativeType var1);

    public abstract Type findType(TypeAlias var1);

    public abstract MemoryManager getMemoryManager();

    public abstract ClosureManager getClosureManager();

    public abstract <T> ObjectReferenceManager<T> newObjectReferenceManager();

    public abstract int getLastError();

    public abstract void setLastError(int var1);

    public abstract long addressMask();

    public abstract int addressSize();

    public abstract int longSize();

    public abstract ByteOrder byteOrder();

    public abstract boolean isCompatible(Runtime var1);

    private static final class SingletonHolder {
        public static final Runtime SYSTEM_RUNTIME = FFIProvider.getSystemProvider().getRuntime();

        private SingletonHolder() {
        }
    }
}

