/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.javatests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.python.core.PyJavaPackage;
import org.python.core.PyModule;
import org.python.util.PythonInterpreter;

public class Issue2455Test {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final PythonInterpreter interpreter = new PythonInterpreter();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test(timeout=60000L)
    public void testJavaModule() throws IOException, InterruptedException {
        File example1 = this.temporaryFolder.newFolder(new String[]{"example1"});
        File example2 = this.temporaryFolder.newFolder(new String[]{"example2"});
        this.createJavaFile(example1, "SomeClass");
        this.createInitFile(example2);
        this.interpreter.exec("import sys");
        this.interpreter.exec("sys.path.append('" + this.temporaryFolder.getRoot().toString() + "')");
        this.interpreter.exec("import " + example1.getName());
        this.interpreter.exec("import " + example2.getName());
        Assert.assertTrue((boolean)(this.interpreter.eval(example1.getName()) instanceof PyJavaPackage));
        Assert.assertTrue((boolean)(this.interpreter.eval(example2.getName()) instanceof PyModule));
        this.createJavaFile(example2, "OtherClass");
        this.evaluate(example1.getName() + ".SomeClass");
        this.evaluate(example2.getName() + ".OtherClass");
    }

    private void createJavaFile(File packageFolder, String className) throws IOException, InterruptedException {
        String javaCode = "package " + packageFolder.getName() + ";" + NEW_LINE + "public class " + className + " {}" + NEW_LINE;
        File javaFile = new File(packageFolder, className + ".java");
        this.createFile(javaFile, javaCode);
        this.compileJavaFile(javaFile);
    }

    private void compileJavaFile(File javaFile) {
        JavaCompiler compiler2 = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler2.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(new ArrayList<File>(Arrays.asList(javaFile)));
        compiler2.getTask(null, fileManager, null, null, null, compilationUnits).call();
    }

    private void createInitFile(File directory) throws IOException {
        File jythonFile = new File(directory, "__init__.py");
        this.createFile(jythonFile, "print 'within __init__.py'");
    }

    private void createFile(File file, String text2) throws IOException {
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text2);
            writer.flush();
        }
    }

    private void evaluate(String className) {
        Assert.assertEquals((Object)("<type '" + className + "'>"), (Object)this.interpreter.eval(className).toString());
    }
}

