/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.python.core.BytecodeNotification;
import org.python.core.ContainsPyBytecode;
import org.python.core.Py;
import org.python.core.PyBytecode;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;
import org.python.objectweb.asm.ClassReader;
import org.python.util.Generic;
import org.scijava.jython.shaded.javax.xml.bind.DatatypeConverter;

public class BytecodeLoader {
    public static Class<?> makeClass(String name, byte[] data, Class<?> ... referents) {
        Loader loader2 = new Loader();
        for (Class<?> referent : referents) {
            try {
                ClassLoader cur = referent.getClassLoader();
                if (cur == null) continue;
                loader2.addParent(cur);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Class<?> c = loader2.loadClassFromBytes(name, data);
        if (ContainsPyBytecode.class.isAssignableFrom(c)) {
            try {
                BytecodeLoader.fixPyBytecode(c);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        BytecodeNotification.notify(name, data, c);
        return c;
    }

    public static Class<?> makeClass(String name, List<Class<?>> referents, byte[] data) {
        if (referents != null) {
            return BytecodeLoader.makeClass(name, data, referents.toArray(new Class[referents.size()]));
        }
        return BytecodeLoader.makeClass(name, data, new Class[0]);
    }

    private static PyCode parseSerializedCode(String code_str) throws IOException, ClassNotFoundException {
        byte[] b = DatatypeConverter.parseBase64Binary((String)code_str);
        ByteArrayInputStream bi = new ByteArrayInputStream(b);
        ObjectInputStream si = new ObjectInputStream(bi);
        PyBytecode meth_code = (PyBytecode)si.readObject();
        si.close();
        bi.close();
        return meth_code;
    }

    public static void fixPyBytecode(Class<? extends ContainsPyBytecode> c) throws IllegalAccessException, NoSuchFieldException, IOException, ClassNotFoundException {
        Field[] fields;
        for (Field fld : fields = c.getDeclaredFields()) {
            Field codeField;
            String fldName = fld.getName();
            if (!fldName.startsWith("___")) continue;
            String[] splt = (fldName = fldName.substring(3)).split("_");
            if (splt[0].equals("0")) {
                codeField = c.getDeclaredField(fldName = fldName.substring(2));
                if (codeField.get(null) != null) continue;
                codeField.set(null, BytecodeLoader.parseSerializedCode((String)fld.get(null)));
                continue;
            }
            if (!splt[1].equals("0") || (codeField = c.getDeclaredField(fldName = fldName.substring(splt[0].length() + splt[1].length() + 2))).get(null) != null) continue;
            int len = Integer.parseInt(splt[0]);
            StringBuilder blt = new StringBuilder((String)fld.get(null));
            int pos = 1;
            while (pos < len) {
                int pos0 = pos;
                for (Field fldPart : fields) {
                    String[] splt2;
                    String partName = fldPart.getName();
                    if (partName.length() == fldName.length() || !partName.startsWith("___") || !partName.endsWith(fldName) || Integer.parseInt((splt2 = partName.substring(3).split("_"))[1]) != pos) continue;
                    blt.append((String)fldPart.get(null));
                    if (++pos == len) break;
                }
                if (pos0 != pos) continue;
                throw new RuntimeException("Invalid PyBytecode splitting in " + c.getName() + ":\nSplit-index " + pos + " wasn't found.");
            }
            codeField.set(null, BytecodeLoader.parseSerializedCode(blt.toString()));
        }
    }

    public static PyCode makeCode(String name, byte[] data, String filename) {
        try {
            Class<?> c = BytecodeLoader.makeClass(name, data, new Class[0]);
            Object o = c.getConstructor(String.class).newInstance(filename);
            PyCode result2 = ((PyRunnable)o).getMain();
            return result2;
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }

    public static class Loader
    extends URLClassLoader {
        private List<ClassLoader> parents = Generic.list();

        public Loader() {
            super(new URL[0]);
            this.parents.add(imp.getSyspathJavaLoader());
        }

        public void addParent(ClassLoader referent) {
            if (!this.parents.contains(referent)) {
                this.parents.add(0, referent);
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            for (ClassLoader loader2 : this.parents) {
                try {
                    return loader2.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        public Class<?> loadClassFromBytes(String name, byte[] data) {
            if (name.endsWith("$py")) {
                try {
                    ClassReader cr = new ClassReader(data);
                    name = cr.getClassName().replace('/', '.');
                }
                catch (RuntimeException cr) {
                    // empty catch block
                }
            }
            Class<?> c = this.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
            this.resolveClass(c);
            return c;
        }
    }
}

