/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.stax.events;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.python.apache.xerces.stax.DefaultNamespaceContext;
import org.python.apache.xerces.stax.events.ElementImpl;
import org.scijava.jython.shaded.javax.xml.namespace.NamespaceContext;
import org.scijava.jython.shaded.javax.xml.namespace.QName;
import org.scijava.jython.shaded.javax.xml.stream.Location;
import org.scijava.jython.shaded.javax.xml.stream.XMLStreamException;
import org.scijava.jython.shaded.javax.xml.stream.events.Attribute;
import org.scijava.jython.shaded.javax.xml.stream.events.Namespace;
import org.scijava.jython.shaded.javax.xml.stream.events.StartElement;

public final class StartElementImpl
extends ElementImpl
implements StartElement {
    private static final Comparator QNAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            QName qName = (QName)object;
            QName qName2 = (QName)object2;
            return qName.toString().compareTo(qName2.toString());
        }
    };
    private final Map fAttributes;
    private final NamespaceContext fNamespaceContext;

    public StartElementImpl(QName qName, Iterator iterator, Iterator iterator2, NamespaceContext namespaceContext, Location location) {
        super(qName, true, iterator2, location);
        if (iterator != null && iterator.hasNext()) {
            this.fAttributes = new TreeMap(QNAME_COMPARATOR);
            do {
                Attribute attribute = (Attribute)iterator.next();
                this.fAttributes.put(attribute.getName(), attribute);
            } while (iterator.hasNext());
        } else {
            this.fAttributes = Collections.EMPTY_MAP;
        }
        this.fNamespaceContext = namespaceContext != null ? namespaceContext : DefaultNamespaceContext.getInstance();
    }

    public Iterator getAttributes() {
        return ElementImpl.createImmutableIterator(this.fAttributes.values().iterator());
    }

    public Attribute getAttributeByName(QName qName) {
        return (Attribute)this.fAttributes.get(qName);
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public String getNamespaceURI(String string2) {
        return this.fNamespaceContext.getNamespaceURI(string2);
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            Iterator iterator;
            writer.write(60);
            QName qName = this.getName();
            String string2 = qName.getPrefix();
            if (string2 != null && string2.length() > 0) {
                writer.write(string2);
                writer.write(58);
            }
            writer.write(qName.getLocalPart());
            Iterator iterator2 = this.getNamespaces();
            while (iterator2.hasNext()) {
                iterator = (Namespace)iterator2.next();
                writer.write(32);
                iterator.writeAsEncodedUnicode(writer);
            }
            iterator = this.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                writer.write(32);
                attribute.writeAsEncodedUnicode(writer);
            }
            writer.write(62);
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }
}

