/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.model.docu.entities;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.scenarioo.api.rules.CharacterChecker;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Labels {
    @XmlElement(name="label")
    private Set<String> labels = new LinkedHashSet<String>();

    public Labels addLabel(String label) {
        CharacterChecker.checkLabel(label);
        this.labels.add(label);
        return this;
    }

    public void setLabels(Set<String> labels) {
        this.checkLabels(labels);
        this.labels = new LinkedHashSet<String>(labels);
    }

    public Set<String> getLabels() {
        if (this.labels == null) {
            this.labels = new HashSet<String>();
        }
        return this.labels;
    }

    private void checkLabels(Set<String> labels) {
        if (labels == null) {
            throw new NullPointerException("Labels must not be null.");
        }
        for (String label : labels) {
            CharacterChecker.checkLabel(label);
        }
    }

    public int size() {
        return this.labels.size();
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public boolean contains(Object o) {
        return this.labels.contains(o);
    }

    public Iterator<String> iterator() {
        return this.labels.iterator();
    }

    public Object[] toArray() {
        return this.labels.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.labels.toArray(a);
    }

    public boolean add(String e) {
        return this.labels.add(e);
    }

    public boolean remove(Object o) {
        return this.labels.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.labels.containsAll(c);
    }

    public boolean addAll(Collection<? extends String> c) {
        return this.labels.addAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.labels.retainAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.labels.removeAll(c);
    }

    public void clear() {
        this.labels.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Labels other = (Labels)obj;
        return !(this.labels == null ? other.labels != null : !this.labels.equals(other.labels));
    }
}

