/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.scenarioo.api.exception.ResourceNotFoundException;
import org.scenarioo.api.files.ObjectFromDirectory;
import org.scenarioo.api.util.xml.ScenarioDocuXMLUtil;

public class ScenarioDocuXMLFileUtil {
    public static <T> void marshal(T object, File destFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            ScenarioDocuXMLUtil.marshal(object, fos);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not marshall Object of type " + object.getClass().getName() + " into file: " + destFile.getAbsolutePath(), e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close file output stream for " + destFile.getAbsolutePath(), e);
            }
        }
    }

    public static <T> T unmarshal(Class<T> targetClass, File srcFile) {
        if (!srcFile.exists()) {
            throw new ResourceNotFoundException(srcFile.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(srcFile);
            T t = ScenarioDocuXMLUtil.unmarshal(targetClass, fis);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not unmarshall " + srcFile.getAbsolutePath(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close file input stream for " + srcFile.getAbsolutePath(), e);
            }
        }
    }

    public static <T> List<T> unmarshalListOfFiles(Class<T> targetClass, List<File> files) {
        ArrayList<T> result = new ArrayList<T>();
        for (File file : files) {
            result.add(ScenarioDocuXMLFileUtil.unmarshal(targetClass, file));
        }
        return result;
    }

    public static <T> List<ObjectFromDirectory<T>> unmarshalListOfFilesWithDirNames(List<File> files, Class<T> targetClass, Class<?> ... classesToBind) {
        ArrayList<ObjectFromDirectory<T>> result = new ArrayList<ObjectFromDirectory<T>>();
        for (File file : files) {
            result.add(new ObjectFromDirectory<T>(ScenarioDocuXMLFileUtil.unmarshal(targetClass, file), file.getParentFile().getName()));
        }
        return result;
    }
}

