/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api.util.files;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scenarioo.api.exception.ResourceNotFoundException;
import org.scenarioo.api.util.files.AlphanumericFileComparator;

public class FilesUtil {
    private FilesUtil() {
    }

    public static String decodeName(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported UTF-8 charset. Scenarioo needs to run on a JVM or server environment that supports 'UTF-8'.", e);
        }
    }

    public static String encodeName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported UTF-8 charset. Scenarioo needs to run on a JVM or server environment that supports 'UTF-8'.", e);
        }
    }

    public static File[] listFiles(File directory) {
        File[] files = directory.listFiles();
        Arrays.sort(files, new AlphanumericFileComparator());
        return files;
    }

    public static List<File> getListOfFiles(File directory) {
        ArrayList<File> result = new ArrayList<File>();
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceNotFoundException(directory.getAbsolutePath());
        }
        for (File file : FilesUtil.listFiles(directory)) {
            if (file.isDirectory()) continue;
            result.add(file);
        }
        return result;
    }

    public static List<File> getListOfFilesFromSubdirs(File directory, String filename) {
        ArrayList<File> result = new ArrayList<File>();
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceNotFoundException(directory.getAbsolutePath());
        }
        for (File subDir : FilesUtil.listFiles(directory)) {
            File file;
            if (!subDir.isDirectory() || !(file = new File(subDir, filename)).exists()) continue;
            result.add(file);
        }
        return result;
    }
}

