/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api.rules;

import java.util.Map;
import org.scenarioo.api.rules.CharacterChecker;
import org.scenarioo.model.docu.entities.generic.Details;
import org.scenarioo.model.docu.entities.generic.ObjectDescription;
import org.scenarioo.model.docu.entities.generic.ObjectReference;
import org.scenarioo.model.docu.entities.generic.ObjectTreeNode;

public class DetailsChecker {
    public static void checkIdentifiers(Details details) {
        if (details == null) {
            return;
        }
        Map<String, Object> properties = details.getProperties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            DetailsChecker.checkIdentifiers(value);
        }
    }

    private static void checkIdentifiers(Object value) {
        if (value instanceof ObjectDescription) {
            DetailsChecker.checkIdentifiers((ObjectDescription)value);
        } else if (value instanceof ObjectReference) {
            DetailsChecker.checkIdentifiers((ObjectReference)value);
        } else if (value instanceof ObjectTreeNode) {
            DetailsChecker.checkIdentifiers((ObjectTreeNode)value);
        }
    }

    private static void checkIdentifiers(ObjectReference objectReference) {
        CharacterChecker.checkIdentifier(objectReference.getType());
        CharacterChecker.checkIdentifier(objectReference.getName());
    }

    private static void checkIdentifiers(ObjectDescription objectDescription) {
        CharacterChecker.checkIdentifier(objectDescription.getType());
        CharacterChecker.checkIdentifier(objectDescription.getName());
        DetailsChecker.checkIdentifiers(objectDescription.getDetails());
    }

    private static void checkIdentifiers(ObjectTreeNode<?> objectTreeNode) {
        DetailsChecker.checkIdentifiers(objectTreeNode.getItem());
        DetailsChecker.checkIdentifiers(objectTreeNode.getDetails());
        DetailsChecker.checkChildNodes(objectTreeNode);
    }

    private static void checkChildNodes(ObjectTreeNode<?> objectTreeNode) {
        if (objectTreeNode.getChildren() == null) {
            return;
        }
        for (ObjectTreeNode childNode : objectTreeNode.getChildren()) {
            DetailsChecker.checkIdentifiers(childNode);
        }
    }
}

