/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api.files;

import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import org.scenarioo.api.util.files.FilesUtil;

public class ScenarioDocuFiles {
    private static final String DIRECTORY_NAME_SCENARIO_SCREENSHOTS = "screenshots";
    private static final String DIRECTORY_NAME_SCENARIO_STEPS = "steps";
    private static final String FILE_NAME_SCENARIO = "scenario.xml";
    private static final String FILE_NAME_CASE = "usecase.xml";
    private static final String FILE_NAME_BUILD = "build.xml";
    private static final String FILE_NAME_BRANCH = "branch.xml";
    private static NumberFormat THREE_DIGIT_NUM_FORMAT = ScenarioDocuFiles.createNumberFormatWithMinimumIntegerDigits(3);
    private final File rootDirectory;

    public ScenarioDocuFiles(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void assertRootDirectoryExists() {
        if (!this.rootDirectory.exists()) {
            throw new IllegalArgumentException("Directory for docu content generation does not exist: " + this.rootDirectory.getAbsolutePath());
        }
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getBranchDirectory(String branchName) {
        File branchDirectory = new File(this.rootDirectory, FilesUtil.encodeName(branchName));
        return branchDirectory;
    }

    public File getBranchFile(String branchName) {
        return new File(this.getBranchDirectory(branchName), FILE_NAME_BRANCH);
    }

    public List<File> getBranchFiles() {
        return FilesUtil.getListOfFilesFromSubdirs(this.rootDirectory, FILE_NAME_BRANCH);
    }

    public File getBuildDirectory(String branchName, String buildName) {
        File buildDirectory = new File(this.getBranchDirectory(branchName), FilesUtil.encodeName(buildName));
        return buildDirectory;
    }

    public File getBuildFile(String branchName, String buildName) {
        return new File(this.getBuildDirectory(branchName, buildName), FILE_NAME_BUILD);
    }

    public List<File> getBuildFiles(String branchName) {
        return FilesUtil.getListOfFilesFromSubdirs(this.getBranchDirectory(branchName), FILE_NAME_BUILD);
    }

    public File getUseCaseDirectory(String branchName, String buildName, String useCaseName) {
        File branchDirectory = new File(this.getBuildDirectory(branchName, buildName), FilesUtil.encodeName(useCaseName));
        return branchDirectory;
    }

    public File getUseCaseFile(String branchName, String buildName, String useCaseName) {
        return new File(this.getUseCaseDirectory(branchName, buildName, useCaseName), FILE_NAME_CASE);
    }

    public List<File> getUseCaseFiles(String branchName, String buildName) {
        return FilesUtil.getListOfFilesFromSubdirs(this.getBuildDirectory(branchName, buildName), FILE_NAME_CASE);
    }

    public File getScenarioDirectory(String branchName, String buildName, String useCaseName, String scenarioName) {
        File branchDirectory = new File(this.getUseCaseDirectory(branchName, buildName, useCaseName), FilesUtil.encodeName(scenarioName));
        return branchDirectory;
    }

    public File getScenarioFile(String branchName, String buildName, String useCaseName, String scenarioName) {
        return new File(this.getScenarioDirectory(branchName, buildName, useCaseName, scenarioName), FILE_NAME_SCENARIO);
    }

    public List<File> getScenarioFiles(String branchName, String buildName, String useCaseName) {
        return FilesUtil.getListOfFilesFromSubdirs(this.getUseCaseDirectory(branchName, buildName, useCaseName), FILE_NAME_SCENARIO);
    }

    public File getStepsDirectory(String branchName, String buildName, String useCaseName, String scenarioName) {
        File branchDirectory = new File(this.getScenarioDirectory(branchName, buildName, useCaseName, scenarioName), DIRECTORY_NAME_SCENARIO_STEPS);
        return branchDirectory;
    }

    public File getStepFile(String branchName, String buildName, String useCaseName, String scenarioName, int stepIndex) {
        return new File(this.getStepsDirectory(branchName, buildName, useCaseName, scenarioName), THREE_DIGIT_NUM_FORMAT.format(stepIndex) + ".xml");
    }

    public List<File> getStepFiles(String branchName, String buildName, String useCaseName, String scenarioName) {
        return FilesUtil.getListOfFiles(this.getStepsDirectory(branchName, buildName, useCaseName, scenarioName));
    }

    public File getScreenshotsDirectory(String branchName, String buildName, String useCaseName, String scenarioName) {
        return new File(this.getScenarioDirectory(branchName, buildName, useCaseName, scenarioName), DIRECTORY_NAME_SCENARIO_SCREENSHOTS);
    }

    public File getScreenshotFile(String branchName, String buildName, String useCaseName, String scenarioName, int stepIndex) {
        return new File(this.getScreenshotsDirectory(branchName, buildName, useCaseName, scenarioName), THREE_DIGIT_NUM_FORMAT.format(stepIndex) + ".png");
    }

    private static NumberFormat createNumberFormatWithMinimumIntegerDigits(int minimumIntegerDigits) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
        return numberFormat;
    }
}

