/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.scenarioo.api.configuration.ScenarioDocuGeneratorConfiguration;
import org.scenarioo.api.exception.ScenarioDocuSaveException;
import org.scenarioo.api.exception.ScenarioDocuTimeoutException;
import org.scenarioo.api.files.ScenarioDocuFiles;
import org.scenarioo.api.rules.CharacterChecker;
import org.scenarioo.api.rules.DetailsChecker;
import org.scenarioo.api.util.xml.ScenarioDocuXMLFileUtil;
import org.scenarioo.model.docu.entities.Branch;
import org.scenarioo.model.docu.entities.Build;
import org.scenarioo.model.docu.entities.Scenario;
import org.scenarioo.model.docu.entities.Step;
import org.scenarioo.model.docu.entities.StepDescription;
import org.scenarioo.model.docu.entities.UseCase;

public class ScenarioDocuWriter {
    private final ScenarioDocuFiles docuFiles;
    private final String branchName;
    private final String buildName;
    private final ExecutorService asyncWriteExecutor = ScenarioDocuWriter.newAsyncWriteExecutor();
    private final List<RuntimeException> caughtExceptions = new ArrayList<RuntimeException>();

    public ScenarioDocuWriter(File destinationRootDirectory, String branchName, String buildName) {
        CharacterChecker.checkIdentifier(branchName);
        CharacterChecker.checkIdentifier(buildName);
        this.docuFiles = new ScenarioDocuFiles(destinationRootDirectory);
        this.branchName = branchName;
        this.buildName = buildName;
        this.createBuildDirectoryIfNotYetExists();
    }

    public void saveBranchDescription(final Branch branch) {
        CharacterChecker.checkIdentifier(branch.getName());
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File destBranchFile = ScenarioDocuWriter.this.docuFiles.getBranchFile(ScenarioDocuWriter.this.branchName);
                ScenarioDocuXMLFileUtil.marshal(branch, destBranchFile);
            }
        });
    }

    public void saveBuildDescription(final Build build) {
        CharacterChecker.checkIdentifier(build.getName());
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File destBuildFile = ScenarioDocuWriter.this.docuFiles.getBuildFile(ScenarioDocuWriter.this.branchName, ScenarioDocuWriter.this.buildName);
                ScenarioDocuXMLFileUtil.marshal(build, destBuildFile);
            }
        });
    }

    public void saveUseCase(final UseCase useCase) {
        CharacterChecker.checkIdentifier(useCase.getName());
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File destCaseDir = ScenarioDocuWriter.this.getUseCaseDirectory(useCase.getName());
                ScenarioDocuWriter.this.createDirectoryIfNotYetExists(destCaseDir);
                File destCaseFile = ScenarioDocuWriter.this.docuFiles.getUseCaseFile(ScenarioDocuWriter.this.branchName, ScenarioDocuWriter.this.buildName, useCase.getName());
                ScenarioDocuXMLFileUtil.marshal(useCase, destCaseFile);
            }
        });
    }

    public void saveScenario(UseCase useCase, Scenario scenario) {
        this.saveScenario(useCase.getName(), scenario);
    }

    public void saveScenario(final String useCaseName, final Scenario scenario) {
        CharacterChecker.checkIdentifier(useCaseName);
        CharacterChecker.checkIdentifier(scenario.getName());
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File destScenarioDir = ScenarioDocuWriter.this.getScenarioDirectory(useCaseName, scenario.getName());
                ScenarioDocuWriter.this.createDirectoryIfNotYetExists(destScenarioDir);
                File destScenarioFile = ScenarioDocuWriter.this.docuFiles.getScenarioFile(ScenarioDocuWriter.this.branchName, ScenarioDocuWriter.this.buildName, useCaseName, scenario.getName());
                ScenarioDocuXMLFileUtil.marshal(scenario, destScenarioFile);
            }
        });
    }

    public void saveStep(UseCase useCase, Scenario scenario, Step step) {
        this.saveStep(useCase.getName(), scenario.getName(), step);
    }

    public void saveStep(final String useCaseName, final String scenarioName, final Step step) {
        this.checkSaveStepPreconditions(useCaseName, scenarioName, step);
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File destStepsDir = ScenarioDocuWriter.this.getScenarioStepsDirectory(useCaseName, scenarioName);
                ScenarioDocuWriter.this.createDirectoryIfNotYetExists(destStepsDir);
                ScenarioDocuWriter.this.calculateScreenshotFileNameIfNotSetWorkaround(useCaseName, scenarioName, step);
                File destStepFile = ScenarioDocuWriter.this.docuFiles.getStepFile(ScenarioDocuWriter.this.branchName, ScenarioDocuWriter.this.buildName, useCaseName, scenarioName, step.getStepDescription().getIndex());
                ScenarioDocuXMLFileUtil.marshal(step, destStepFile);
            }
        });
    }

    private void checkSaveStepPreconditions(String useCaseName, String scenarioName, Step step) {
        CharacterChecker.checkIdentifier(useCaseName);
        CharacterChecker.checkIdentifier(scenarioName);
        if (step.getPage() != null) {
            CharacterChecker.checkIdentifier(step.getPage().getName());
        }
        if (step.getMetadata() != null) {
            DetailsChecker.checkIdentifiers(step.getMetadata().getDetails());
        }
        if (step.getStepDescription() != null) {
            DetailsChecker.checkIdentifiers(step.getStepDescription().getDetails());
        }
    }

    private void calculateScreenshotFileNameIfNotSetWorkaround(String useCaseName, String scenarioName, Step step) {
        StepDescription stepDescription = step.getStepDescription();
        if (stepDescription != null && stepDescription.getScreenshotFileName() == null) {
            File imageFile = this.docuFiles.getScreenshotFile(this.branchName, this.buildName, useCaseName, scenarioName, stepDescription.getIndex());
            stepDescription.setScreenshotFileName(imageFile.getName());
        }
    }

    public File getScreenshotsDirectory(String usecaseName, String scenarioName) {
        return this.docuFiles.getScreenshotsDirectory(this.branchName, this.buildName, CharacterChecker.checkIdentifier(usecaseName), CharacterChecker.checkIdentifier(scenarioName));
    }

    public File getScreenshotFile(String usecaseName, String scenarioName, int stepIndex) {
        return this.docuFiles.getScreenshotFile(this.branchName, this.buildName, CharacterChecker.checkIdentifier(usecaseName), CharacterChecker.checkIdentifier(scenarioName), stepIndex);
    }

    public void saveScreenshotAsPng(final String useCaseName, final String scenarioName, final int stepIndex, final byte[] pngScreenshot) {
        CharacterChecker.checkIdentifier(useCaseName);
        CharacterChecker.checkIdentifier(scenarioName);
        this.executeAsyncWrite(new Runnable(){

            @Override
            public void run() {
                File screenshotFile = ScenarioDocuWriter.this.docuFiles.getScreenshotFile(ScenarioDocuWriter.this.branchName, ScenarioDocuWriter.this.buildName, useCaseName, scenarioName, stepIndex);
                try {
                    FileUtils.writeByteArrayToFile((File)screenshotFile, (byte[])pngScreenshot);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not write image: " + screenshotFile.getAbsolutePath(), e);
                }
            }
        });
    }

    public void flush() {
        int timeoutInSeconds = ScenarioDocuGeneratorConfiguration.INSTANCE.getTimeoutWaitingForWritingFinishedInSeconds();
        this.asyncWriteExecutor.shutdown();
        try {
            boolean terminated = this.asyncWriteExecutor.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
            if (!terminated) {
                this.asyncWriteExecutor.shutdownNow();
                throw new ScenarioDocuTimeoutException("Timeout occured while waiting for docu files to be written. Writing of files took too long.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Async writing of scenarioo docu files was interrupted", e);
        }
        if (!this.caughtExceptions.isEmpty()) {
            throw new ScenarioDocuSaveException(this.caughtExceptions);
        }
    }

    private File getBuildDirectory() {
        return this.docuFiles.getBuildDirectory(this.branchName, this.buildName);
    }

    private File getUseCaseDirectory(String useCaseName) {
        return this.docuFiles.getUseCaseDirectory(this.branchName, this.buildName, useCaseName);
    }

    private File getScenarioDirectory(String useCaseName, String scenarioName) {
        return this.docuFiles.getScenarioDirectory(this.branchName, this.buildName, useCaseName, scenarioName);
    }

    private File getScenarioStepsDirectory(String useCaseName, String scenarioName) {
        return this.docuFiles.getStepsDirectory(this.branchName, this.buildName, useCaseName, scenarioName);
    }

    private void createBuildDirectoryIfNotYetExists() {
        this.createDirectoryIfNotYetExists(this.getBuildDirectory());
    }

    private void createDirectoryIfNotYetExists(File directory) {
        this.docuFiles.assertRootDirectoryExists();
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void executeAsyncWrite(final Runnable writeTask) {
        this.asyncWriteExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    writeTask.run();
                }
                catch (RuntimeException e) {
                    ScenarioDocuWriter.this.caughtExceptions.add(e);
                }
            }
        });
    }

    private static ExecutorService newAsyncWriteExecutor() {
        return new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(ScenarioDocuGeneratorConfiguration.INSTANCE.getAsyncWriteBufferSize()));
    }
}

