/*
 * Decompiled with CFR 0.152.
 */
package org.scenarioo.api;

import java.io.File;
import java.util.List;
import org.scenarioo.api.files.ObjectFromDirectory;
import org.scenarioo.api.files.ScenarioDocuFiles;
import org.scenarioo.api.rules.CharacterChecker;
import org.scenarioo.api.util.xml.ScenarioDocuXMLFileUtil;
import org.scenarioo.model.docu.entities.Branch;
import org.scenarioo.model.docu.entities.Build;
import org.scenarioo.model.docu.entities.Scenario;
import org.scenarioo.model.docu.entities.Step;
import org.scenarioo.model.docu.entities.UseCase;

public class ScenarioDocuReader {
    private final ScenarioDocuFiles docuFiles;

    public ScenarioDocuReader(File rootDirectory) {
        this.docuFiles = new ScenarioDocuFiles(rootDirectory);
    }

    public Branch loadBranch(String branchName) {
        File file = this.docuFiles.getBranchFile(CharacterChecker.checkIdentifier(branchName));
        return ScenarioDocuXMLFileUtil.unmarshal(Branch.class, file);
    }

    public List<Branch> loadBranches() {
        List<File> branchFiles = this.docuFiles.getBranchFiles();
        return ScenarioDocuXMLFileUtil.unmarshalListOfFiles(Branch.class, branchFiles);
    }

    public Build loadBuild(String branchName, String buildName) {
        File file = this.docuFiles.getBuildFile(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName));
        return ScenarioDocuXMLFileUtil.unmarshal(Build.class, file);
    }

    public List<ObjectFromDirectory<Build>> loadBuilds(String branchName) {
        List<File> buildFiles = this.docuFiles.getBuildFiles(CharacterChecker.checkIdentifier(branchName));
        return ScenarioDocuXMLFileUtil.unmarshalListOfFilesWithDirNames(buildFiles, Build.class, new Class[0]);
    }

    public List<UseCase> loadUsecases(String branchName, String buildName) {
        List<File> files = this.docuFiles.getUseCaseFiles(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName));
        return ScenarioDocuXMLFileUtil.unmarshalListOfFiles(UseCase.class, files);
    }

    public UseCase loadUsecase(String branchName, String buildName, String useCaseName) {
        File file = this.docuFiles.getUseCaseFile(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName));
        return ScenarioDocuXMLFileUtil.unmarshal(UseCase.class, file);
    }

    public List<Scenario> loadScenarios(String branchName, String buildName, String useCaseName) {
        List<File> files = this.docuFiles.getScenarioFiles(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName));
        return ScenarioDocuXMLFileUtil.unmarshalListOfFiles(Scenario.class, files);
    }

    public Scenario loadScenario(String branchName, String buildName, String useCaseName, String scenarioName) {
        File file = this.docuFiles.getScenarioFile(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName), CharacterChecker.checkIdentifier(scenarioName));
        return ScenarioDocuXMLFileUtil.unmarshal(Scenario.class, file);
    }

    public List<Step> loadSteps(String branchName, String buildName, String useCaseName, String scenarioName) {
        List<File> files = this.docuFiles.getStepFiles(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName), CharacterChecker.checkIdentifier(scenarioName));
        return ScenarioDocuXMLFileUtil.unmarshalListOfFiles(Step.class, files);
    }

    public Step loadStep(String branchName, String buildName, String useCaseName, String scenarioName, int stepIndex) {
        File file = this.docuFiles.getStepFile(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName), CharacterChecker.checkIdentifier(scenarioName), stepIndex);
        return ScenarioDocuXMLFileUtil.unmarshal(Step.class, file);
    }

    public File getScreenshotFile(String branchName, String buildName, String useCaseName, String scenarioName, String imageName) {
        return new File(this.docuFiles.getScreenshotsDirectory(CharacterChecker.checkIdentifier(branchName), CharacterChecker.checkIdentifier(buildName), CharacterChecker.checkIdentifier(useCaseName), CharacterChecker.checkIdentifier(scenarioName)), imageName);
    }
}

