/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.net.InetSocketAddress;
import java.util.List;
import org.scassandra.http.client.ClientConnection;
import org.scassandra.http.client.ConnectionReport;

public class ClosedConnectionReport
implements ConnectionReport {
    @SerializedName(value="operation")
    private final CloseType closeType;
    @SerializedName(value="closed_connections")
    private final List<ClientConnection> connections;

    public ClosedConnectionReport(CloseType closeType, List<ClientConnection> connections) {
        this.closeType = closeType;
        this.connections = connections;
    }

    public CloseType getCloseType() {
        return this.closeType;
    }

    @Override
    public List<ClientConnection> getConnections() {
        return this.connections;
    }

    @Override
    public List<InetSocketAddress> getAddresses() {
        return Lists.transform(this.connections, (Function)new Function<ClientConnection, InetSocketAddress>(){

            public InetSocketAddress apply(ClientConnection input) {
                return input.getAddress();
            }
        });
    }

    public static enum CloseType {
        CLOSE,
        RESET,
        HALFCLOSE;

    }
}

