/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.ActivityRequestFailed;
import org.scassandra.http.client.BatchExecution;
import org.scassandra.http.client.Connection;
import org.scassandra.http.client.PreparedStatementExecution;
import org.scassandra.http.client.PreparedStatementPreparation;
import org.scassandra.http.client.Query;
import org.scassandra.http.client.types.GsonCqlTypeDeserialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityClient {
    private static final String REQUEST_FOR_QUERIES_FAILED = "Request for queries failed";
    private static final String REQUEST_FOR_CONNECTIONS_FAILED = "Request for connections failed";
    private static final String REQUEST_FAILED = "Request failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityClient.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter(CqlType.class, (Object)new GsonCqlTypeDeserialiser()).create();
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private final String connectionUrl;
    private final String queryUrl;
    private final String preparedStatementExecutionUrl;
    private final String batchUrl;
    private final String preparedStatementPreparationUrl;

    public static ActivityClientBuilder builder() {
        return new ActivityClientBuilder();
    }

    private ActivityClient(String host, int port, int socketTimeout) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(socketTimeout);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(socketTimeout);
        requestBuilder = requestBuilder.setSocketTimeout(socketTimeout);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.httpClient = builder.build();
        this.connectionUrl = "http://" + host + ":" + port + "/connection";
        this.queryUrl = "http://" + host + ":" + port + "/query";
        this.preparedStatementExecutionUrl = "http://" + host + ":" + port + "/prepared-statement-execution";
        this.batchUrl = "http://" + host + ":" + port + "/batch-execution";
        this.preparedStatementPreparationUrl = "http://" + host + ":" + port + "/prepared-statement-preparation";
    }

    public List<Query> retrieveQueries() {
        HttpGet get = new HttpGet(this.queryUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Object[] queries = (Query[])this.gson.fromJson(body, Query[].class);
            LOGGER.debug("Parsed queries {}", (Object)Arrays.toString(queries));
            return Arrays.asList(queries);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_QUERIES_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FOR_QUERIES_FAILED, e);
        }
    }

    public List<Connection> retrieveConnections() {
        HttpGet get = new HttpGet(this.connectionUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Object[] connections = (Connection[])this.gson.fromJson(body, Connection[].class);
            LOGGER.debug("Parsed connections {}", (Object)Arrays.toString(connections));
            return Arrays.asList(connections);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_CONNECTIONS_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FOR_CONNECTIONS_FAILED, e);
        }
    }

    public void clearConnections() {
        this.httpDelete(this.connectionUrl, "Clearing of connections failed");
    }

    public void clearQueries() {
        this.httpDelete(this.queryUrl, "Clearing of queries failed");
    }

    public void clearPreparedStatementPreparations() {
        this.httpDelete(this.preparedStatementPreparationUrl, "Clearing of prepared statement preparations failed");
    }

    public List<PreparedStatementPreparation> retrievePreparedStatementPreparations() {
        HttpGet get = new HttpGet(this.preparedStatementPreparationUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Non 200 status code when retrieving prepared statement preparations %s", statusCode);
                LOGGER.info(errorMessage);
                throw new ActivityRequestFailed(errorMessage);
            }
            Object[] preparations = (PreparedStatementPreparation[])this.gson.fromJson(body, PreparedStatementPreparation[].class);
            LOGGER.debug("Parsed prepared statement preparations {}", (Object)Arrays.toString(preparations));
            return Arrays.asList(preparations);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FAILED, e);
        }
    }

    public void clearPreparedStatementExecutions() {
        this.httpDelete(this.preparedStatementExecutionUrl, "Clearing of prepared statement executions failed");
    }

    public void clearAllRecordedActivity() {
        this.clearConnections();
        this.clearQueries();
        this.clearPreparedStatementExecutions();
        this.clearBatchExecutions();
        this.clearPreparedStatementPreparations();
    }

    public List<PreparedStatementExecution> retrievePreparedStatementExecutions() {
        HttpGet get = new HttpGet(this.preparedStatementExecutionUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Non 200 status code when retrieving prepared statement executions %s", statusCode);
                LOGGER.info(errorMessage);
                throw new ActivityRequestFailed(errorMessage);
            }
            Object[] executions = (PreparedStatementExecution[])this.gson.fromJson(body, PreparedStatementExecution[].class);
            LOGGER.debug("Parsed prepared statement executions {}", (Object)Arrays.toString(executions));
            return Arrays.asList(executions);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FAILED, e);
        }
    }

    public List<BatchExecution> retrieveBatches() {
        HttpGet get = new HttpGet(this.batchUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Object[] batchExecutions = (BatchExecution[])this.gson.fromJson(body, BatchExecution[].class);
            LOGGER.debug("Parsed batch executions {}", (Object)Arrays.toString(batchExecutions));
            return Arrays.asList(batchExecutions);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_CONNECTIONS_FAILED, (Throwable)e);
            throw new ActivityRequestFailed(REQUEST_FOR_CONNECTIONS_FAILED, e);
        }
    }

    public void clearBatchExecutions() {
        this.httpDelete(this.batchUrl, "Clearing of batch executions failed");
    }

    private void httpDelete(String url, String warningMessage) {
        HttpDelete delete = new HttpDelete(url);
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)delete);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            LOGGER.warn(warningMessage, (Throwable)e);
            throw new ActivityRequestFailed(warningMessage, e);
        }
    }

    public static class ActivityClientBuilder {
        private String host = "localhost";
        private int port = 8043;
        private int socketTimeout = 1000;

        private ActivityClientBuilder() {
        }

        public ActivityClientBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public ActivityClientBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public ActivityClientBuilder withSocketTimeout(int timeout) {
            this.socketTimeout = timeout;
            return this;
        }

        public ActivityClient build() {
            return new ActivityClient(this.host, this.port, this.socketTimeout);
        }
    }
}

