/*
 * Copyright (C) 2014 Christopher Batey
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.scassandra.http.client.types;

import org.scassandra.cql.CqlType;

public class ColumnMetadata {
    private final String name;
    private final CqlType type;

    public static ColumnMetadata column(String name, CqlType type) {
        return new ColumnMetadata(name, type);
    }

    private ColumnMetadata(String name, CqlType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public CqlType getType() {
        return type;
    }
}
