/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.io.Serializable;
import munit.diff.Diff$;
import munit.diff.DiffOptions;
import munit.diff.DiffOptions$;
import munit.diff.console.AnsiColors$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u0014(\u00011B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0003\"A!\n\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003B\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011A-\t\u000bq\u0003A1B'\t\u000fu\u0003!\u0019!C\u0001\u0001\"1a\f\u0001Q\u0001\n\u0005Cqa\u0018\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004a\u0001\u0001\u0006I!\u0011\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u00191\u0007\u0001)A\u0005G\"9q\r\u0001b\u0001\n\u0003\u0011\u0007B\u00025\u0001A\u0003%1\rC\u0004j\u0001\t\u0007I\u0011\u0001!\t\r)\u0004\u0001\u0015!\u0003B\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001d1\b!%A\u0005\u0002]Da\u0001\u001d\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003\u001b\u0001A\u0011BA\b\u000f\u001d\t\tc\nE\u0001\u0003G1aAJ\u0014\t\u0002\u0005\u0015\u0002BB*\u001c\t\u0003\t)\u0004C\u0004\u00028m!\t!!\u000f\t\u000f\u0005%1\u0004\"\u0001\u0002D!1\u0001o\u0007C\u0001\u0003\u001bBa![\u000e\u0005\u0002\u0005e\u0003bBA27\u0011%\u0011Q\r\u0005\b\u0003[ZB\u0011BA8\u0011\u001d\tYh\u0007C\u0005\u0003{Bq!a#\u001c\t\u0013\ti\tC\u0005\u0002\u0014n\t\t\u0011\"\u0003\u0002\u0016\n!A)\u001b4g\u0015\tA\u0013&\u0001\u0003eS\u001a4'\"\u0001\u0016\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!DH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001hK\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!aO\u0018\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003w=\n\u0001b\u001c2uC&tW\rZ\u000b\u0002\u0003B\u0011!I\u0012\b\u0003\u0007\u0012\u0003\"AN\u0018\n\u0005\u0015{\u0013A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!R\u0018\u0002\u0013=\u0014G/Y5oK\u0012\u0004\u0013\u0001C3ya\u0016\u001cG/\u001a3\u0002\u0013\u0015D\b/Z2uK\u0012\u0004\u0013aB8qi&|gn]\u000b\u0002\u001dB\u0011q\nU\u0007\u0002O%\u0011\u0011k\n\u0002\f\t&4gm\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q!QKV,Y!\ty\u0005\u0001C\u0003@\u000f\u0001\u0007\u0011\tC\u0003K\u000f\u0001\u0007\u0011\tC\u0003M\u000f\u0001\u0007a\nF\u0002V5nCQa\u0010\u0005A\u0002\u0005CQA\u0013\u0005A\u0002\u0005\u000b1\u0002Z5gM>\u0003H/[8og\u0006iqN\u0019;bS:,Gm\u00117fC:\fab\u001c2uC&tW\rZ\"mK\u0006t\u0007%A\u0007fqB,7\r^3e\u00072,\u0017M\\\u0001\u000fKb\u0004Xm\u0019;fI\u000ecW-\u00198!\u00035y'\r^1j]\u0016$G*\u001b8fgV\t1\rE\u00025I\u0006K!!\u001a \u0003\u0007M+\u0017/\u0001\bpER\f\u0017N\\3e\u0019&tWm\u001d\u0011\u0002\u001b\u0015D\b/Z2uK\u0012d\u0015N\\3t\u00039)\u0007\u0010]3di\u0016$G*\u001b8fg\u0002\n1\"\u001e8jM&,G\rR5gM\u0006aQO\\5gS\u0016$G)\u001b4gA\u00059\u0011n]#naRLX#A7\u0011\u00059r\u0017BA80\u0005\u001d\u0011un\u001c7fC:\fAb\u0019:fCR,'+\u001a9peR$2!\u0011:u\u0011\u0015\u0019X\u00031\u0001B\u0003\u0015!\u0018\u000e\u001e7f\u0011\u001d)X\u0003%AA\u00025\f!\u0004\u001d:j]R|%\r^1j]\u0016$\u0017i]*ue&\u0004X*\u0019:hS:\fac\u0019:fCR,'+\u001a9peR$C-\u001a4bk2$HEM\u000b\u0002q*\u0012Q._\u0016\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0013Ut7\r[3dW\u0016$'BA@0\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007a(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR\u0019\u0011)a\u0002\t\u000bM<\u0002\u0019A!\u0002)\r\u0014X-\u0019;f\t&4gm\u00148msJ+\u0007o\u001c:u)\u0005\t\u0015\u0001F1qa\u0016tG\rR5gM>sG.\u001f*fa>\u0014H\u000f\u0006\u0003\u0002\u0012\u0005]\u0001c\u0001\u0018\u0002\u0014%\u0019\u0011QC\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033I\u00029AA\u000e\u0003\t\u0019(\rE\u00025\u0003;I1!a\b?\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006!A)\u001b4g!\ty5d\u0005\u0003\u001c[\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0003S>T!!!\r\u0002\t)\fg/Y\u0005\u0004{\u0005-BCAA\u0012\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tY$a\u0010\u0002BQ\u0019Q+!\u0010\t\u000b1k\u00029\u0001(\t\u000b}j\u0002\u0019A!\t\u000b)k\u0002\u0019A!\u0015\r\u0005\u0015\u0013\u0011JA&)\r\t\u0015q\t\u0005\u0006\u0019z\u0001\u001dA\u0014\u0005\u0006\u007fy\u0001\r!\u0011\u0005\u0006\u0015z\u0001\r!\u0011\u000b\t\u0003\u001f\n\u0019&!\u0016\u0002XQ\u0019\u0011)!\u0015\t\u000b1{\u00029\u0001(\t\u000b}z\u0002\u0019A!\t\u000b){\u0002\u0019A!\t\u000bM|\u0002\u0019A!\u0015\r\u0005m\u0013qLA1)\r\t\u0015Q\f\u0005\u0006\u0019\u0002\u0002\u001dA\u0014\u0005\u0006\u007f\u0001\u0002\r!\u0011\u0005\u0006\u0015\u0002\u0002\r!Q\u0001\u000eCN\u001cFO]5q\u001b\u0006\u0014x-\u001b8\u0015\u000b\u0005\u000b9'!\u001b\t\u000b}\n\u0003\u0019A!\t\r\u0005-\u0014\u00051\u0001n\u0003\u00111G.Y4\u0002\r!,\u0017\rZ3s)\u0011\t\t(a\u001e\u0015\r\u0005E\u00111OA;\u0011\u001d\tIB\ta\u0002\u00037AQ\u0001\u0014\u0012A\u00049Ca!!\u001f#\u0001\u0004\t\u0015!\u0001;\u0002#\r\u0014X-\u0019;f+:Lg-[3e\t&4g\r\u0006\u0004\u0002\u0000\u0005\r\u0015q\u0011\u000b\u0004\u0003\u0006\u0005\u0005\"\u0002'$\u0001\bq\u0005BBACG\u0001\u00071-\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\tIi\ta\u0001G\u00069!/\u001a<jg\u0016$\u0017AD:qY&$\u0018J\u001c;p\u0019&tWm\u001d\u000b\u0004G\u0006=\u0005BBAII\u0001\u0007\u0011)\u0001\u0004tiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by#\u0001\u0003mC:<\u0017\u0002BAQ\u00037\u0013aa\u00142kK\u000e$\b")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final DiffOptions options;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public static Diff apply(String obtained, String expected, DiffOptions options) {
        return Diff$.MODULE$.apply(obtained, expected, options);
    }

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public DiffOptions options() {
        return this.options;
    }

    private DiffOptions diffOptions() {
        return this.options();
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title)) ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            Diff$.MODULE$.munit$diff$Diff$$header("Obtained", sb, this.diffOptions());
            sb.append("\n");
            sb.append(Diff$.MODULE$.munit$diff$Diff$$asStripMargin(this.obtainedClean(), printObtainedAsStripMargin));
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public String createReport(String title) {
        return this.createReport(title, this.options().obtainedAsStripMargin());
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        Diff$.MODULE$.munit$diff$Diff$$header("Diff", sb, this.diffOptions());
        sb.append(" (");
        AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.LightRed(), this.options().ansi(), (Function1<StringBuilder, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            x$1.append("- expected");
            return BoxedUnit.UNIT;
        }, sb);
        sb.append(", ");
        AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.LightGreen(), this.options().ansi(), (Function1<StringBuilder, BoxedUnit>)(Function1 & Serializable)x$2 -> {
            x$2.append("+ obtained");
            return BoxedUnit.UNIT;
        }, sb);
        sb.append(")\n");
        sb.append(this.unifiedDiff());
    }

    public Diff(String obtained, String expected, DiffOptions options) {
        this.obtained = obtained;
        this.expected = expected;
        this.options = options;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = Diff$.MODULE$.munit$diff$Diff$$splitIntoLines(this.obtainedClean());
        this.expectedLines = Diff$.MODULE$.munit$diff$Diff$$splitIntoLines(this.expectedClean());
        this.unifiedDiff = Diff$.MODULE$.munit$diff$Diff$$createUnifiedDiff(this.expectedLines(), this.obtainedLines(), this.diffOptions());
    }

    public Diff(String obtained, String expected) {
        this(obtained, expected, (DiffOptions)Predef$.MODULE$.implicitly((Object)DiffOptions$.MODULE$.default()));
    }
}

