/*
 * Decompiled with CFR 0.152.
 */
package munit.diff;

import java.util.ArrayList;
import java.util.List;
import munit.diff.Delta;
import munit.diff.MyersDiff;
import munit.diff.Patch;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DiffUtils$ {
    public static DiffUtils$ MODULE$;

    static {
        new DiffUtils$();
    }

    public List<String> generateUnifiedDiff(String original, String revised, List<String> originalLines, Patch<String> patch, int contextSize) {
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(new StringBuilder(4).append("--- ").append(original).toString());
            ret.add(new StringBuilder(4).append("+++ ").append(revised).toString());
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            ObjectRef delta = ObjectRef.create((Object)((Delta)patchDeltas.get(0)));
            deltas.add((Delta)delta.elem);
            if (patchDeltas.size() > 1) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), patchDeltas.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                    boolean bl;
                    int position = ((Delta)delta$1.elem).getOriginal().getPosition();
                    Delta nextDelta = (Delta)patchDeltas.get(i);
                    if (position + ((Delta)delta$1.elem).getOriginal().size() + contextSize >= nextDelta.getOriginal().getPosition() - contextSize) {
                        bl = deltas.add(nextDelta);
                    } else {
                        ArrayList<String> curBlock = MODULE$.processDeltas(originalLines, deltas, contextSize);
                        ret.addAll(curBlock);
                        deltas.clear();
                        bl = deltas.add(nextDelta);
                    }
                    delta$1.elem = nextDelta;
                });
            }
            ArrayList<String> curBlock = this.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            return ret;
        }
        return new ArrayList<String>();
    }

    public Patch<String> diff(List<String> original, List<String> revised) {
        return new MyersDiff<String>().diff(original, revised);
    }

    private ArrayList<String> processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        int line = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getOriginal().getPosition(); ++line) {
            buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
        }
        buffer.addAll(this.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < nextDelta.getOriginal().getPosition(); ++line) {
                buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
                ++origTotal;
                ++revTotal;
            }
            buffer.addAll(this.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    private ArrayList<String> getDeltaText(Delta<String> delta) {
        ArrayList<String> buffer = new ArrayList<String>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getOriginal().getLines()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)buffer.add(new StringBuilder(1).append("-").append(line).toString())));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getRevised().getLines()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)buffer.add(new StringBuilder(1).append("+").append(line).toString())));
        return buffer;
    }

    private DiffUtils$() {
        MODULE$ = this;
    }
}

