/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileProgress;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.PerClasspathEntryLookup;

public final class Setup
implements Serializable {
    private PerClasspathEntryLookup perClasspathEntryLookup;
    private boolean skip;
    private Path cachePath;
    private GlobalsCache cache;
    private IncOptions incrementalCompilerOptions;
    private Reporter reporter;
    private Optional<CompileProgress> progress;
    private Optional<AnalysisStore> earlyAnalysisStore;
    private T2<String, String>[] extra;

    public File cacheFile() {
        return this.cachePath.toFile();
    }

    public Setup withCacheFile(File cacheFile) {
        return this.withCachePath(cacheFile.toPath());
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, File _cacheFile, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cacheFile.toPath(), _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, File _cacheFile, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cacheFile.toPath(), _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _extra);
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _extra);
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, Optional<AnalysisStore> _earlyAnalysisStore, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _earlyAnalysisStore, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, Optional<AnalysisStore> _earlyAnalysisStore, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _earlyAnalysisStore, _extra);
    }

    public static Setup create(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, AnalysisStore _earlyAnalysisStore, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _earlyAnalysisStore, _extra);
    }

    public static Setup of(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, AnalysisStore _earlyAnalysisStore, T2<String, String>[] _extra) {
        return new Setup(_perClasspathEntryLookup, _skip, _cachePath, _cache, _incrementalCompilerOptions, _reporter, _progress, _earlyAnalysisStore, _extra);
    }

    protected Setup(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, T2<String, String>[] _extra) {
        this.perClasspathEntryLookup = _perClasspathEntryLookup;
        this.skip = _skip;
        this.cachePath = _cachePath;
        this.cache = _cache;
        this.incrementalCompilerOptions = _incrementalCompilerOptions;
        this.reporter = _reporter;
        this.progress = Optional.empty();
        this.earlyAnalysisStore = Optional.empty();
        this.extra = _extra;
    }

    protected Setup(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, T2<String, String>[] _extra) {
        this.perClasspathEntryLookup = _perClasspathEntryLookup;
        this.skip = _skip;
        this.cachePath = _cachePath;
        this.cache = _cache;
        this.incrementalCompilerOptions = _incrementalCompilerOptions;
        this.reporter = _reporter;
        this.progress = _progress;
        this.earlyAnalysisStore = Optional.empty();
        this.extra = _extra;
    }

    protected Setup(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, T2<String, String>[] _extra) {
        this.perClasspathEntryLookup = _perClasspathEntryLookup;
        this.skip = _skip;
        this.cachePath = _cachePath;
        this.cache = _cache;
        this.incrementalCompilerOptions = _incrementalCompilerOptions;
        this.reporter = _reporter;
        this.progress = Optional.ofNullable(_progress);
        this.earlyAnalysisStore = Optional.empty();
        this.extra = _extra;
    }

    protected Setup(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, Optional<CompileProgress> _progress, Optional<AnalysisStore> _earlyAnalysisStore, T2<String, String>[] _extra) {
        this.perClasspathEntryLookup = _perClasspathEntryLookup;
        this.skip = _skip;
        this.cachePath = _cachePath;
        this.cache = _cache;
        this.incrementalCompilerOptions = _incrementalCompilerOptions;
        this.reporter = _reporter;
        this.progress = _progress;
        this.earlyAnalysisStore = _earlyAnalysisStore;
        this.extra = _extra;
    }

    protected Setup(PerClasspathEntryLookup _perClasspathEntryLookup, boolean _skip, Path _cachePath, GlobalsCache _cache, IncOptions _incrementalCompilerOptions, Reporter _reporter, CompileProgress _progress, AnalysisStore _earlyAnalysisStore, T2<String, String>[] _extra) {
        this.perClasspathEntryLookup = _perClasspathEntryLookup;
        this.skip = _skip;
        this.cachePath = _cachePath;
        this.cache = _cache;
        this.incrementalCompilerOptions = _incrementalCompilerOptions;
        this.reporter = _reporter;
        this.progress = Optional.ofNullable(_progress);
        this.earlyAnalysisStore = Optional.ofNullable(_earlyAnalysisStore);
        this.extra = _extra;
    }

    public PerClasspathEntryLookup perClasspathEntryLookup() {
        return this.perClasspathEntryLookup;
    }

    public boolean skip() {
        return this.skip;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    public GlobalsCache cache() {
        return this.cache;
    }

    public IncOptions incrementalCompilerOptions() {
        return this.incrementalCompilerOptions;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Optional<CompileProgress> progress() {
        return this.progress;
    }

    public Optional<AnalysisStore> earlyAnalysisStore() {
        return this.earlyAnalysisStore;
    }

    public T2<String, String>[] extra() {
        return this.extra;
    }

    public Setup withPerClasspathEntryLookup(PerClasspathEntryLookup perClasspathEntryLookup) {
        return new Setup(perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withSkip(boolean skip) {
        return new Setup(this.perClasspathEntryLookup, skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withCachePath(Path cachePath) {
        return new Setup(this.perClasspathEntryLookup, this.skip, cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withCache(GlobalsCache cache) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withIncrementalCompilerOptions(IncOptions incrementalCompilerOptions) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withReporter(Reporter reporter) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, reporter, this.progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withProgress(Optional<CompileProgress> progress) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, progress, this.earlyAnalysisStore, this.extra);
    }

    public Setup withProgress(CompileProgress progress) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, Optional.ofNullable(progress), this.earlyAnalysisStore, this.extra);
    }

    public Setup withEarlyAnalysisStore(Optional<AnalysisStore> earlyAnalysisStore) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, earlyAnalysisStore, this.extra);
    }

    public Setup withEarlyAnalysisStore(AnalysisStore earlyAnalysisStore) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, Optional.ofNullable(earlyAnalysisStore), this.extra);
    }

    public Setup withExtra(T2<String, String>[] extra) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.earlyAnalysisStore, extra);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Setup)) {
            return false;
        }
        Setup o = (Setup)obj;
        return this.perClasspathEntryLookup().equals(o.perClasspathEntryLookup()) && this.skip() == o.skip() && this.cachePath().equals(o.cachePath()) && this.cache().equals(o.cache()) && this.incrementalCompilerOptions().equals(o.incrementalCompilerOptions()) && this.reporter().equals(o.reporter()) && this.progress().equals(o.progress()) && this.earlyAnalysisStore().equals(o.earlyAnalysisStore()) && Arrays.deepEquals(this.extra(), o.extra());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.Setup".hashCode()) + this.perClasspathEntryLookup().hashCode()) + Boolean.hashCode(this.skip())) + this.cachePath().hashCode()) + this.cache().hashCode()) + this.incrementalCompilerOptions().hashCode()) + this.reporter().hashCode()) + this.progress().hashCode()) + this.earlyAnalysisStore().hashCode()) + Arrays.deepHashCode(this.extra()));
    }

    public String toString() {
        return "Setup(perClasspathEntryLookup: " + this.perClasspathEntryLookup() + ", skip: " + this.skip() + ", cachePath: " + this.cachePath() + ", cache: " + this.cache() + ", incrementalCompilerOptions: " + this.incrementalCompilerOptions() + ", reporter: " + this.reporter() + ", progress: " + this.progress() + ", earlyAnalysisStore: " + this.earlyAnalysisStore() + ", extra: " + this.extra() + ")";
    }
}

