/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import xsbti.compile.AnalysisContents;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;

public final class CompileResult
implements AnalysisContents,
Serializable {
    private CompileAnalysis analysis;
    private MiniSetup setup;
    private boolean hasModified;

    @Override
    public CompileAnalysis getAnalysis() {
        return this.analysis;
    }

    @Override
    public MiniSetup getMiniSetup() {
        return this.setup;
    }

    public static CompileResult create(CompileAnalysis compileAnalysis, MiniSetup miniSetup, boolean bl) {
        return new CompileResult(compileAnalysis, miniSetup, bl);
    }

    public static CompileResult of(CompileAnalysis compileAnalysis, MiniSetup miniSetup, boolean bl) {
        return new CompileResult(compileAnalysis, miniSetup, bl);
    }

    protected CompileResult(CompileAnalysis compileAnalysis, MiniSetup miniSetup, boolean bl) {
        this.analysis = compileAnalysis;
        this.setup = miniSetup;
        this.hasModified = bl;
    }

    public CompileAnalysis analysis() {
        return this.analysis;
    }

    public MiniSetup setup() {
        return this.setup;
    }

    public boolean hasModified() {
        return this.hasModified;
    }

    public CompileResult withAnalysis(CompileAnalysis compileAnalysis) {
        return new CompileResult(compileAnalysis, this.setup, this.hasModified);
    }

    public CompileResult withSetup(MiniSetup miniSetup) {
        return new CompileResult(this.analysis, miniSetup, this.hasModified);
    }

    public CompileResult withHasModified(boolean bl) {
        return new CompileResult(this.analysis, this.setup, bl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompileResult)) {
            return false;
        }
        CompileResult compileResult = (CompileResult)object;
        return this.analysis().equals(compileResult.analysis()) && this.setup().equals(compileResult.setup()) && this.hasModified() == compileResult.hasModified();
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (17 + "xsbti.compile.CompileResult".hashCode()) + this.analysis().hashCode()) + this.setup().hashCode()) + Boolean.hashCode(this.hasModified()));
    }

    public String toString() {
        return "CompileResult(analysis: " + this.analysis() + ", setup: " + this.setup() + ", hasModified: " + this.hasModified() + ")";
    }
}

