/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.io.Serializable;
import xsbti.api.Companions;
import xsbti.api.Compilation;
import xsbti.api.Lazy;
import xsbti.api.NameHashes;

public final class AnalyzedClass
implements Serializable {
    private Compilation compilation;
    private String name;
    private Lazy<Companions> api;
    private int apiHash;
    private NameHashes nameHashes;
    private boolean hasMacro;

    public AnalyzedClass(Compilation compilation, String string, Lazy<Companions> lazy, int n, NameHashes nameHashes, boolean bl) {
        this.compilation = compilation;
        this.name = string;
        this.api = lazy;
        this.apiHash = n;
        this.nameHashes = nameHashes;
        this.hasMacro = bl;
    }

    public Compilation compilation() {
        return this.compilation;
    }

    public String name() {
        return this.name;
    }

    public Companions api() {
        return this.api.get();
    }

    public int apiHash() {
        return this.apiHash;
    }

    public NameHashes nameHashes() {
        return this.nameHashes;
    }

    public boolean hasMacro() {
        return this.hasMacro;
    }

    public AnalyzedClass withCompilation(Compilation compilation) {
        return new AnalyzedClass(compilation, this.name, this.api, this.apiHash, this.nameHashes, this.hasMacro);
    }

    public AnalyzedClass withName(String string) {
        return new AnalyzedClass(this.compilation, string, this.api, this.apiHash, this.nameHashes, this.hasMacro);
    }

    public AnalyzedClass withApi(Lazy<Companions> lazy) {
        return new AnalyzedClass(this.compilation, this.name, lazy, this.apiHash, this.nameHashes, this.hasMacro);
    }

    public AnalyzedClass withApiHash(int n) {
        return new AnalyzedClass(this.compilation, this.name, this.api, n, this.nameHashes, this.hasMacro);
    }

    public AnalyzedClass withNameHashes(NameHashes nameHashes) {
        return new AnalyzedClass(this.compilation, this.name, this.api, this.apiHash, nameHashes, this.hasMacro);
    }

    public AnalyzedClass withHasMacro(boolean bl) {
        return new AnalyzedClass(this.compilation, this.name, this.api, this.apiHash, this.nameHashes, bl);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }
}

