/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import xsbti.Maybe;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.ExternalHooks;
import xsbti.compile.IncOptions;

public class IncOptionsUtil {
    public static final String TRANSITIVE_STEP_KEY = "transitiveStep";
    public static final String RECOMPILE_ALL_FRACTION_KEY = "recompileAllFraction";
    public static final String RELATIONS_DEBUG_KEY = "relationsDebug";
    public static final String API_DEBUG_KEY = "apiDebug";
    public static final String API_DIFF_CONTEXT_SIZE_KEY = "apiDiffContextSize";
    public static final String API_DUMP_DIRECTORY_KEY = "apiDumpDirectory";
    public static final String RECOMPILE_ON_MACRO_DEF_KEY = "recompileOnMacroDef";
    public static final String USE_OPTIMIZED_SEALED = "useOptimizedSealed";
    public static final String LOG_RECOMPILE_ON_MACRO = "logRecompileOnMacro";
    private static final String XSBTI_NOTHING = "NOTHING";

    public static int defaultTransitiveStep() {
        return 3;
    }

    public static double defaultRecompileAllFraction() {
        return 0.5;
    }

    public static boolean defaultRelationsDebug() {
        return false;
    }

    public static boolean defaultApiDebug() {
        return false;
    }

    public static int defaultApiDiffContextSize() {
        return 5;
    }

    public static Maybe<File> defaultApiDumpDirectory() {
        return Maybe.nothing();
    }

    public static Maybe<ClassFileManagerType> defaultClassFileManagerType() {
        return Maybe.nothing();
    }

    public static Maybe<Boolean> defaultRecompileOnMacroDef() {
        return Maybe.nothing();
    }

    public static boolean defaultUseOptimizedSealed() {
        return false;
    }

    public static boolean defaultRecompileOnMacroDefImpl() {
        return true;
    }

    public static boolean getRecompileOnMacroDef(IncOptions incOptions) {
        if (incOptions.recompileOnMacroDef().isDefined()) {
            return (Boolean)incOptions.recompileOnMacroDef().get();
        }
        return IncOptionsUtil.defaultRecompileOnMacroDefImpl();
    }

    public static boolean defaultUseCustomizedFileManager() {
        return false;
    }

    public static boolean defaultStoreApis() {
        return true;
    }

    public static boolean defaultEnabled() {
        return true;
    }

    public static Map<String, String> defaultExtra() {
        return new HashMap<String, String>();
    }

    public static ExternalHooks defaultExternal() {
        return new ExternalHooks(){

            @Override
            public ExternalHooks.Lookup externalLookup() {
                return null;
            }

            @Override
            public ClassFileManager externalClassFileManager() {
                return null;
            }
        };
    }

    public static boolean defaultLogRecompileOnMacro() {
        return true;
    }

    public static IncOptions defaultIncOptions() {
        IncOptions incOptions = new IncOptions(IncOptionsUtil.defaultTransitiveStep(), IncOptionsUtil.defaultRecompileAllFraction(), IncOptionsUtil.defaultRelationsDebug(), IncOptionsUtil.defaultApiDebug(), IncOptionsUtil.defaultApiDiffContextSize(), IncOptionsUtil.defaultApiDumpDirectory(), IncOptionsUtil.defaultClassFileManagerType(), IncOptionsUtil.defaultUseCustomizedFileManager(), IncOptionsUtil.defaultRecompileOnMacroDef(), IncOptionsUtil.defaultUseOptimizedSealed(), IncOptionsUtil.defaultStoreApis(), IncOptionsUtil.defaultEnabled(), IncOptionsUtil.defaultExtra(), IncOptionsUtil.defaultLogRecompileOnMacro(), IncOptionsUtil.defaultExternal());
        return incOptions;
    }

    public static IncOptions fromStringMap(Map<String, String> map) {
        IncOptions incOptions = IncOptionsUtil.defaultIncOptions();
        if (map.containsKey(TRANSITIVE_STEP_KEY)) {
            incOptions = incOptions.withTransitiveStep(Integer.parseInt(map.get(TRANSITIVE_STEP_KEY)));
        }
        if (map.containsKey(RECOMPILE_ALL_FRACTION_KEY)) {
            incOptions = incOptions.withRecompileAllFraction(Double.parseDouble(map.get(RECOMPILE_ALL_FRACTION_KEY)));
        }
        if (map.containsKey(RELATIONS_DEBUG_KEY)) {
            incOptions = incOptions.withRelationsDebug(Boolean.parseBoolean(map.get(RELATIONS_DEBUG_KEY)));
        }
        if (map.containsKey(API_DEBUG_KEY)) {
            incOptions = incOptions.withApiDebug(Boolean.parseBoolean(map.get(API_DEBUG_KEY)));
        }
        if (map.containsKey(API_DIFF_CONTEXT_SIZE_KEY)) {
            incOptions = incOptions.withApiDiffContextSize(Integer.parseInt(map.get(API_DIFF_CONTEXT_SIZE_KEY)));
        }
        if (map.containsKey(API_DUMP_DIRECTORY_KEY)) {
            incOptions = map.get(API_DUMP_DIRECTORY_KEY).equals(XSBTI_NOTHING) ? incOptions.withApiDumpDirectory((Maybe<File>)Maybe.nothing()) : incOptions.withApiDumpDirectory((Maybe<File>)Maybe.just((Object)new File(map.get(API_DUMP_DIRECTORY_KEY))));
        }
        if (map.containsKey(RECOMPILE_ON_MACRO_DEF_KEY)) {
            incOptions = map.get(RECOMPILE_ON_MACRO_DEF_KEY).equals(XSBTI_NOTHING) ? incOptions.withRecompileOnMacroDef((Maybe<Boolean>)Maybe.nothing()) : incOptions.withRecompileOnMacroDef((Maybe<Boolean>)Maybe.just((Object)Boolean.parseBoolean(map.get(RECOMPILE_ON_MACRO_DEF_KEY))));
        }
        if (map.containsKey(LOG_RECOMPILE_ON_MACRO)) {
            incOptions = incOptions.withLogRecompileOnMacro(Boolean.parseBoolean(map.get(LOG_RECOMPILE_ON_MACRO)));
        }
        if (map.containsKey(USE_OPTIMIZED_SEALED)) {
            incOptions = incOptions.withUseOptimizedSealed(Boolean.parseBoolean(map.get(USE_OPTIMIZED_SEALED)));
        }
        return incOptions;
    }
}

