/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.io.File;
import java.io.Serializable;
import xsbti.api.DependencyContext;
import xsbti.api.Source;

public final class ExternalDependency
implements Serializable {
    private File sourceFile;
    private String targetClassName;
    private Source targetSource;
    private DependencyContext context;

    public ExternalDependency(File file, String string, Source source, DependencyContext dependencyContext) {
        this.sourceFile = file;
        this.targetClassName = string;
        this.targetSource = source;
        this.context = dependencyContext;
    }

    public File sourceFile() {
        return this.sourceFile;
    }

    public String targetClassName() {
        return this.targetClassName;
    }

    public Source targetSource() {
        return this.targetSource;
    }

    public DependencyContext context() {
        return this.context;
    }

    public ExternalDependency withSourceFile(File file) {
        return new ExternalDependency(file, this.targetClassName, this.targetSource, this.context);
    }

    public ExternalDependency withTargetClassName(String string) {
        return new ExternalDependency(this.sourceFile, string, this.targetSource, this.context);
    }

    public ExternalDependency withTargetSource(Source source) {
        return new ExternalDependency(this.sourceFile, this.targetClassName, source, this.context);
    }

    public ExternalDependency withContext(DependencyContext dependencyContext) {
        return new ExternalDependency(this.sourceFile, this.targetClassName, this.targetSource, dependencyContext);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExternalDependency)) {
            return false;
        }
        ExternalDependency externalDependency = (ExternalDependency)object;
        return this.sourceFile().equals(externalDependency.sourceFile()) && this.targetClassName().equals(externalDependency.targetClassName()) && this.targetSource().equals(externalDependency.targetSource()) && this.context().equals((Object)externalDependency.context());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (17 + this.sourceFile().hashCode()) + this.targetClassName().hashCode()) + this.targetSource().hashCode()) + this.context().hashCode());
    }

    public String toString() {
        return "ExternalDependency(sourceFile: " + this.sourceFile() + ", " + "targetClassName: " + this.targetClassName() + ", " + "targetSource: " + this.targetSource() + ", " + "context: " + (Object)((Object)this.context()) + ")";
    }
}

