/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.hashing.LongHashFunction;
import org.scalasbt.ipcsocket.UnixDomainServerSocket;
import org.scalasbt.ipcsocket.Win32NamedPipeServerSocket;
import org.scalasbt.ipcsocket.Win32SecurityLevel;
import sbt.internal.ServerAlreadyBootingException;
import sbt.internal.util.Terminal;
import xsbti.AppConfiguration;

public class BootServerSocket
implements AutoCloseable {
    private ServerSocket serverSocket = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicInteger threadId = new AtomicInteger(1);
    private final Future<?> acceptFuture;
    private final ExecutorService service = Executors.newCachedThreadPool(runnable -> new Thread(runnable, "boot-server-socket-thread-" + this.threadId.getAndIncrement()));
    private final Set<ClientSocket> clientSockets = ConcurrentHashMap.newKeySet();
    private final Object lock = new Object();
    private final LinkedBlockingQueue<ClientSocket> clientSocketReads = new LinkedBlockingQueue();
    private final Path socketFile;
    private final AtomicBoolean needInput = new AtomicBoolean(false);
    private final Object writeLock = new Object();
    private final InputStream inputStream = new InputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            if (BootServerSocket.this.clientSockets.isEmpty()) {
                return Terminal.NO_BOOT_CLIENTS_CONNECTED();
            }
            try {
                Object object = BootServerSocket.this.needInput;
                synchronized (object) {
                    BootServerSocket.this.needInput.set(true);
                    BootServerSocket.this.needInput.notifyAll();
                }
                object = (ClientSocket)BootServerSocket.this.clientSocketReads.take();
                int n = (Integer)((ClientSocket)object).bytes.take();
                return n;
            }
            catch (InterruptedException interruptedException) {
                int n = -1;
                return n;
            }
            finally {
                AtomicBoolean atomicBoolean = BootServerSocket.this.needInput;
                synchronized (atomicBoolean) {
                    BootServerSocket.this.needInput.set(false);
                }
            }
        }
    };
    private final OutputStream outputStream = new OutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(clientSocket -> ((ClientSocket)clientSocket).write(n));
            }
        }

        @Override
        public void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(clientSocket -> ((ClientSocket)clientSocket).write(byArray, n, n2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(clientSocket -> ((ClientSocket)clientSocket).flush());
            }
        }
    };
    private final Runnable acceptRunnable = () -> {
        try {
            this.serverSocket.setSoTimeout(5000);
            while (this.running.get()) {
                try {
                    ClientSocket clientSocket = new ClientSocket(this.serverSocket.accept());
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    this.running.set(false);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    };
    static final boolean isWindows = System.getProperty("os.name", "").toLowerCase().startsWith("win");

    public InputStream inputStream() {
        return this.inputStream;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public BootServerSocket(AppConfiguration appConfiguration) throws ServerAlreadyBootingException, IOException {
        Path path = appConfiguration.baseDirectory().toPath().toRealPath(new LinkOption[0]);
        Path path2 = path.resolve("project").resolve("target");
        if (!isWindows) {
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            this.socketFile = Paths.get(BootServerSocket.socketLocation(path), new String[0]);
        } else {
            this.socketFile = null;
        }
        this.serverSocket = BootServerSocket.newSocket(BootServerSocket.socketLocation(path));
        if (this.serverSocket != null) {
            this.running.set(true);
            this.acceptFuture = this.service.submit(this.acceptRunnable);
        } else {
            this.closed.set(true);
            this.acceptFuture = null;
        }
    }

    public static String socketLocation(Path path) throws UnsupportedEncodingException {
        Path path2 = path.resolve("project").resolve("target");
        if (isWindows) {
            long l = LongHashFunction.farmNa().hashBytes(path2.toString().getBytes("UTF-8"));
            return "sbt-load" + l;
        }
        return path.relativize(path2.resolve("sbt-load.sock")).toString();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.clientSockets.forEach(ClientSocket::close);
            if (this.acceptFuture != null) {
                this.acceptFuture.cancel(true);
            }
            this.service.shutdownNow();
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.socketFile != null) {
                    Files.deleteIfExists(this.socketFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static ServerSocket newSocket(String string) throws ServerAlreadyBootingException {
        Win32NamedPipeServerSocket win32NamedPipeServerSocket = null;
        String string2 = BootServerSocket.socketName(string);
        try {
            if (!isWindows) {
                Files.deleteIfExists(Paths.get(string, new String[0]));
            }
            win32NamedPipeServerSocket = isWindows ? new Win32NamedPipeServerSocket(string2, false, Win32SecurityLevel.OWNER_DACL) : new UnixDomainServerSocket(string2);
            return win32NamedPipeServerSocket;
        }
        catch (IOException iOException) {
            throw new ServerAlreadyBootingException();
        }
    }

    private static String socketName(String string) {
        return isWindows ? "\\\\.\\pipe\\" + string : string;
    }

    private class ClientSocket
    implements AutoCloseable {
        final Socket socket;
        final AtomicBoolean alive = new AtomicBoolean(true);
        final Future<?> future;
        private final LinkedBlockingQueue<Integer> bytes = new LinkedBlockingQueue();
        private final AtomicBoolean closed = new AtomicBoolean(false);

        ClientSocket(Socket socket) {
            this.socket = socket;
            BootServerSocket.this.clientSockets.add(this);
            Future<?> future = null;
            try {
                future = BootServerSocket.this.service.submit(() -> {
                    try {
                        Terminal.console().getLines().foreach(string -> {
                            try {
                                this.write((string + System.lineSeparator()).getBytes("UTF-8"));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return 0;
                        });
                        InputStream inputStream = socket.getInputStream();
                        while (this.alive.get()) {
                            try {
                                AtomicBoolean atomicBoolean = BootServerSocket.this.needInput;
                                synchronized (atomicBoolean) {
                                    while (!BootServerSocket.this.needInput.get() && this.alive.get()) {
                                        BootServerSocket.this.needInput.wait();
                                    }
                                }
                                if (!this.alive.get()) continue;
                                socket.getOutputStream().write(5);
                                int n = inputStream.read();
                                if (n != -1) {
                                    this.bytes.put(n);
                                    BootServerSocket.this.clientSocketReads.put(this);
                                    continue;
                                }
                                this.alive.set(false);
                            }
                            catch (IOException iOException) {
                                this.alive.set(false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.alive.set(false);
            }
            this.future = future;
        }

        private void write(int n) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(n);
                }
            }
            catch (IOException iOException) {
                this.alive.set(false);
                this.close();
            }
        }

        private void write(byte[] byArray) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(byArray);
                }
            }
            catch (IOException iOException) {
                this.alive.set(false);
                this.close();
            }
        }

        private void write(byte[] byArray, int n, int n2) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(byArray, n, n2);
                }
            }
            catch (IOException iOException) {
                this.alive.set(false);
                this.close();
            }
        }

        private void flush() {
            try {
                this.socket.getOutputStream().flush();
            }
            catch (IOException iOException) {
                this.alive.set(false);
                this.close();
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                if (this.alive.get()) {
                    this.write(2);
                    this.bytes.forEach(this::write);
                    this.bytes.clear();
                    this.write(3);
                    this.flush();
                }
                this.alive.set(false);
                if (this.future != null) {
                    this.future.cancel(true);
                }
                try {
                    this.socket.getOutputStream().close();
                    this.socket.getInputStream().close();
                    if (!System.getProperty("os.name", "").toLowerCase().startsWith("win")) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BootServerSocket.this.clientSockets.remove(this);
            }
        }
    }
}

